/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.RelocationBatchErrorEntry;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class RelocationBatchResultEntry {
    public static final RelocationBatchResultEntry OTHER = new RelocationBatchResultEntry().withTag(Tag.OTHER);
    private Tag _tag;
    private Metadata successValue;
    private RelocationBatchErrorEntry failureValue;

    private RelocationBatchResultEntry() {
    }

    private RelocationBatchResultEntry withTag(Tag _tag) {
        RelocationBatchResultEntry result = new RelocationBatchResultEntry();
        result._tag = _tag;
        return result;
    }

    private RelocationBatchResultEntry withTagAndSuccess(Tag _tag, Metadata successValue) {
        RelocationBatchResultEntry result = new RelocationBatchResultEntry();
        result._tag = _tag;
        result.successValue = successValue;
        return result;
    }

    private RelocationBatchResultEntry withTagAndFailure(Tag _tag, RelocationBatchErrorEntry failureValue) {
        RelocationBatchResultEntry result = new RelocationBatchResultEntry();
        result._tag = _tag;
        result.failureValue = failureValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isSuccess() {
        return this._tag == Tag.SUCCESS;
    }

    public static RelocationBatchResultEntry success(Metadata value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationBatchResultEntry().withTagAndSuccess(Tag.SUCCESS, value);
    }

    public Metadata getSuccessValue() {
        if (this._tag != Tag.SUCCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.SUCCESS, but was Tag." + this._tag.name());
        }
        return this.successValue;
    }

    public boolean isFailure() {
        return this._tag == Tag.FAILURE;
    }

    public static RelocationBatchResultEntry failure(RelocationBatchErrorEntry value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelocationBatchResultEntry().withTagAndFailure(Tag.FAILURE, value);
    }

    public RelocationBatchErrorEntry getFailureValue() {
        if (this._tag != Tag.FAILURE) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILURE, but was Tag." + this._tag.name());
        }
        return this.failureValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.successValue, this.failureValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RelocationBatchResultEntry) {
            RelocationBatchResultEntry other = (RelocationBatchResultEntry)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case SUCCESS: {
                    return this.successValue == other.successValue || this.successValue.equals(other.successValue);
                }
                case FAILURE: {
                    return this.failureValue == other.failureValue || this.failureValue.equals(other.failureValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<RelocationBatchResultEntry> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RelocationBatchResultEntry value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case SUCCESS: {
                    g2.writeStartObject();
                    this.writeTag("success", g2);
                    g2.writeFieldName("success");
                    Metadata.Serializer.INSTANCE.serialize(value.successValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case FAILURE: {
                    g2.writeStartObject();
                    this.writeTag("failure", g2);
                    g2.writeFieldName("failure");
                    RelocationBatchErrorEntry.Serializer.INSTANCE.serialize(value.failureValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public RelocationBatchResultEntry deserialize(JsonParser p) throws IOException, JsonParseException {
            RelocationBatchResultEntry value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("success".equals(tag)) {
                Metadata fieldValue = null;
                Serializer.expectField("success", p);
                fieldValue = (Metadata)Metadata.Serializer.INSTANCE.deserialize(p);
                value = RelocationBatchResultEntry.success(fieldValue);
            } else if ("failure".equals(tag)) {
                RelocationBatchErrorEntry fieldValue = null;
                Serializer.expectField("failure", p);
                fieldValue = RelocationBatchErrorEntry.Serializer.INSTANCE.deserialize(p);
                value = RelocationBatchResultEntry.failure(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        SUCCESS,
        FAILURE,
        OTHER;

    }
}

