/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class PropertiesSearchMode {
    public static final PropertiesSearchMode OTHER = new PropertiesSearchMode().withTag(Tag.OTHER);
    private Tag _tag;
    private String fieldNameValue;

    private PropertiesSearchMode() {
    }

    private PropertiesSearchMode withTag(Tag _tag) {
        PropertiesSearchMode result = new PropertiesSearchMode();
        result._tag = _tag;
        return result;
    }

    private PropertiesSearchMode withTagAndFieldName(Tag _tag, String fieldNameValue) {
        PropertiesSearchMode result = new PropertiesSearchMode();
        result._tag = _tag;
        result.fieldNameValue = fieldNameValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isFieldName() {
        return this._tag == Tag.FIELD_NAME;
    }

    public static PropertiesSearchMode fieldName(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new PropertiesSearchMode().withTagAndFieldName(Tag.FIELD_NAME, value);
    }

    public String getFieldNameValue() {
        if (this._tag != Tag.FIELD_NAME) {
            throw new IllegalStateException("Invalid tag: required Tag.FIELD_NAME, but was Tag." + this._tag.name());
        }
        return this.fieldNameValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.fieldNameValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PropertiesSearchMode) {
            PropertiesSearchMode other = (PropertiesSearchMode)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case FIELD_NAME: {
                    return this.fieldNameValue == other.fieldNameValue || this.fieldNameValue.equals(other.fieldNameValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<PropertiesSearchMode> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PropertiesSearchMode value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case FIELD_NAME: {
                    g2.writeStartObject();
                    this.writeTag("field_name", g2);
                    g2.writeFieldName("field_name");
                    StoneSerializers.string().serialize(value.fieldNameValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public PropertiesSearchMode deserialize(JsonParser p) throws IOException, JsonParseException {
            PropertiesSearchMode value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("field_name".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("field_name", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = PropertiesSearchMode.fieldName(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        FIELD_NAME,
        OTHER;

    }
}

