/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.util.gradle;

import com.kantenkugel.discordbot.versioncheck.RepoType;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GradleUtil {
    public static final Collection<Pair<String, String>> DEFAULT_PLUGINS = Arrays.asList(new ImmutablePair<String, Object>("java", null), new ImmutablePair<String, Object>("application", null), new ImmutablePair<String, String>("com.github.johnrengelman.shadow", "6.0.0"));
    public static final String SHADOW_VERSION = "6.0.0";

    public static String getBuildFile(boolean kotlin, Collection<Pair<String, String>> plugins, String mainClassName, String version, String sourceCompatibility, List<VersionedItem> items, boolean pretty) {
        char quote = kotlin ? (char)'\"' : '\'';
        String base = GradleUtil.getPluginsBlock(kotlin, plugins) + "\n\nmainClassName = " + quote + mainClassName + quote + "\nversion " + quote + version + quote + "\nsourceCompatibility = " + sourceCompatibility + "\n\n" + GradleUtil.getRepositoryBlock(kotlin, items) + "\n\n" + GradleUtil.getDependencyBlock(kotlin, items, pretty) + "\n\n";
        if (kotlin) {
            return base + "tasks.withType<JavaCompile> {\n    options.encoding = \"UTF-8\"\n    options.isIncremental = true\n}\n";
        }
        return base + "compileJava.options.encoding = 'UTF-8'\n";
    }

    public static String getDependencyBlock(boolean kotlin, List<VersionedItem> items, boolean pretty) {
        StringBuilder text = new StringBuilder("dependencies {\n");
        for (VersionedItem item : items) {
            text.append("    ").append(GradleUtil.getDependencyString(kotlin, item, pretty)).append("\n");
        }
        text.append("}");
        return text.toString();
    }

    public static String getDependencyString(boolean kotlin, VersionedItem item, boolean pretty) {
        if (kotlin) {
            return String.format("implementation(\"%s:%s:%s\")", item.getGroupId(), item.getArtifactId(), item.getVersion());
        }
        if (pretty) {
            return String.format("implementation group: '%s', name: '%s', version: '%s'", item.getGroupId(), item.getArtifactId(), item.getVersion());
        }
        return String.format("implementation '%s:%s:%s'", item.getGroupId(), item.getArtifactId(), item.getVersion());
    }

    public static String getPluginsBlock(boolean kotlin, Collection<Pair<String, String>> plugins) {
        StringBuilder text = new StringBuilder("plugins {\n");
        String indentation = "    ";
        for (Pair<String, String> plugin : plugins) {
            if (kotlin) {
                text.append(indentation);
                if (plugin.getRight() != null) {
                    text.append("id(\"").append(plugin.getLeft()).append("\") version \"").append(plugin.getRight()).append('\"');
                } else {
                    text.append(plugin.getLeft());
                }
            } else {
                text.append(indentation).append("id '").append(plugin.getLeft()).append("'");
                if (plugin.getRight() != null) {
                    text.append(" version '").append(plugin.getRight()).append("'");
                }
            }
            text.append("\n");
        }
        text.append("}");
        return text.toString();
    }

    public static String getRepositoryBlock(boolean kotlin, List<VersionedItem> items) {
        StringBuilder text = new StringBuilder("repositories {\n");
        items.stream().filter(item -> item.getRepoType() != null).flatMap(item -> item.getAllRepositories().stream()).filter(Objects::nonNull).distinct().sorted().forEach(repoType -> text.append(GradleUtil.getRepositoryString(kotlin, repoType, "    ")).append("\n"));
        text.append("}");
        return text.toString();
    }

    public static String getRepositoryString(boolean kotlin, RepoType repoType, String indentation) {
        if (indentation == null) {
            indentation = "";
        }
        if (repoType.getGradleName() != null) {
            return indentation + repoType.getGradleName() + "()";
        }
        if (kotlin) {
            return indentation + "maven(\"" + repoType.getRepoBase() + "\")";
        }
        return indentation + "maven {\n" + indentation + "    name '" + repoType.getName() + "'\n" + indentation + "    url '" + repoType.getRepoBase() + "'\n" + indentation + "}";
    }
}

