/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.MobileClientPlatform;
import com.dropbox.core.v2.teamlog.DeviceSessionLogInfo;
import com.dropbox.core.v2.teamlog.MobileSessionLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class MobileDeviceSessionLogInfo
extends DeviceSessionLogInfo {
    protected final MobileSessionLogInfo sessionInfo;
    protected final String deviceName;
    protected final MobileClientPlatform clientType;
    protected final String clientVersion;
    protected final String osVersion;
    protected final String lastCarrier;

    public MobileDeviceSessionLogInfo(String deviceName, MobileClientPlatform clientType, String ipAddress, Date created, Date updated, MobileSessionLogInfo sessionInfo, String clientVersion, String osVersion, String lastCarrier) {
        super(ipAddress, created, updated);
        this.sessionInfo = sessionInfo;
        if (deviceName == null) {
            throw new IllegalArgumentException("Required value for 'deviceName' is null");
        }
        this.deviceName = deviceName;
        if (clientType == null) {
            throw new IllegalArgumentException("Required value for 'clientType' is null");
        }
        this.clientType = clientType;
        this.clientVersion = clientVersion;
        this.osVersion = osVersion;
        this.lastCarrier = lastCarrier;
    }

    public MobileDeviceSessionLogInfo(String deviceName, MobileClientPlatform clientType) {
        this(deviceName, clientType, null, null, null, null, null, null, null);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public MobileClientPlatform getClientType() {
        return this.clientType;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    public MobileSessionLogInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getLastCarrier() {
        return this.lastCarrier;
    }

    public static Builder newBuilder(String deviceName, MobileClientPlatform clientType) {
        return new Builder(deviceName, clientType);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sessionInfo, this.deviceName, this.clientType, this.clientVersion, this.osVersion, this.lastCarrier});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MobileDeviceSessionLogInfo other = (MobileDeviceSessionLogInfo)obj;
            return !(this.deviceName != other.deviceName && !this.deviceName.equals(other.deviceName) || this.clientType != other.clientType && !this.clientType.equals((Object)other.clientType) || this.ipAddress != other.ipAddress && (this.ipAddress == null || !this.ipAddress.equals(other.ipAddress)) || this.created != other.created && (this.created == null || !this.created.equals(other.created)) || this.updated != other.updated && (this.updated == null || !this.updated.equals(other.updated)) || this.sessionInfo != other.sessionInfo && (this.sessionInfo == null || !this.sessionInfo.equals(other.sessionInfo)) || this.clientVersion != other.clientVersion && (this.clientVersion == null || !this.clientVersion.equals(other.clientVersion)) || this.osVersion != other.osVersion && (this.osVersion == null || !this.osVersion.equals(other.osVersion)) || this.lastCarrier != other.lastCarrier && (this.lastCarrier == null || !this.lastCarrier.equals(other.lastCarrier)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MobileDeviceSessionLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MobileDeviceSessionLogInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            this.writeTag("mobile_device_session", g2);
            g2.writeFieldName("device_name");
            StoneSerializers.string().serialize(value.deviceName, g2);
            g2.writeFieldName("client_type");
            MobileClientPlatform.Serializer.INSTANCE.serialize(value.clientType, g2);
            if (value.ipAddress != null) {
                g2.writeFieldName("ip_address");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.ipAddress, g2);
            }
            if (value.created != null) {
                g2.writeFieldName("created");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.created, g2);
            }
            if (value.updated != null) {
                g2.writeFieldName("updated");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.updated, g2);
            }
            if (value.sessionInfo != null) {
                g2.writeFieldName("session_info");
                StoneSerializers.nullableStruct(MobileSessionLogInfo.Serializer.INSTANCE).serialize(value.sessionInfo, g2);
            }
            if (value.clientVersion != null) {
                g2.writeFieldName("client_version");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.clientVersion, g2);
            }
            if (value.osVersion != null) {
                g2.writeFieldName("os_version");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.osVersion, g2);
            }
            if (value.lastCarrier != null) {
                g2.writeFieldName("last_carrier");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.lastCarrier, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public MobileDeviceSessionLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_lastCarrier;
            String f_osVersion;
            String f_clientVersion;
            MobileSessionLogInfo f_sessionInfo;
            Date f_updated;
            Date f_created;
            String f_ipAddress;
            MobileClientPlatform f_clientType;
            String f_deviceName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("mobile_device_session".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_deviceName = null;
                f_clientType = null;
                f_ipAddress = null;
                f_created = null;
                f_updated = null;
                f_sessionInfo = null;
                f_clientVersion = null;
                f_osVersion = null;
                f_lastCarrier = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("device_name".equals(field)) {
                        f_deviceName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("client_type".equals(field)) {
                        f_clientType = MobileClientPlatform.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("ip_address".equals(field)) {
                        f_ipAddress = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("created".equals(field)) {
                        f_created = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("updated".equals(field)) {
                        f_updated = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("session_info".equals(field)) {
                        f_sessionInfo = StoneSerializers.nullableStruct(MobileSessionLogInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("client_version".equals(field)) {
                        f_clientVersion = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("os_version".equals(field)) {
                        f_osVersion = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("last_carrier".equals(field)) {
                        f_lastCarrier = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_deviceName == null) {
                    throw new JsonParseException(p, "Required field \"device_name\" missing.");
                }
                if (f_clientType == null) {
                    throw new JsonParseException(p, "Required field \"client_type\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MobileDeviceSessionLogInfo value = new MobileDeviceSessionLogInfo(f_deviceName, f_clientType, f_ipAddress, f_created, f_updated, f_sessionInfo, f_clientVersion, f_osVersion, f_lastCarrier);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends DeviceSessionLogInfo.Builder {
        protected final String deviceName;
        protected final MobileClientPlatform clientType;
        protected MobileSessionLogInfo sessionInfo;
        protected String clientVersion;
        protected String osVersion;
        protected String lastCarrier;

        protected Builder(String deviceName, MobileClientPlatform clientType) {
            if (deviceName == null) {
                throw new IllegalArgumentException("Required value for 'deviceName' is null");
            }
            this.deviceName = deviceName;
            if (clientType == null) {
                throw new IllegalArgumentException("Required value for 'clientType' is null");
            }
            this.clientType = clientType;
            this.sessionInfo = null;
            this.clientVersion = null;
            this.osVersion = null;
            this.lastCarrier = null;
        }

        public Builder withSessionInfo(MobileSessionLogInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
            return this;
        }

        public Builder withClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        public Builder withOsVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder withLastCarrier(String lastCarrier) {
            this.lastCarrier = lastCarrier;
            return this;
        }

        @Override
        public Builder withIpAddress(String ipAddress) {
            super.withIpAddress(ipAddress);
            return this;
        }

        @Override
        public Builder withCreated(Date created) {
            super.withCreated(created);
            return this;
        }

        @Override
        public Builder withUpdated(Date updated) {
            super.withUpdated(updated);
            return this;
        }

        @Override
        public MobileDeviceSessionLogInfo build() {
            return new MobileDeviceSessionLogInfo(this.deviceName, this.clientType, this.ipAddress, this.created, this.updated, this.sessionInfo, this.clientVersion, this.osVersion, this.lastCarrier);
        }
    }
}

