/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.SharedLinkSettingsError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ModifySharedLinkSettingsError {
    public static final ModifySharedLinkSettingsError SHARED_LINK_NOT_FOUND = new ModifySharedLinkSettingsError().withTag(Tag.SHARED_LINK_NOT_FOUND);
    public static final ModifySharedLinkSettingsError SHARED_LINK_ACCESS_DENIED = new ModifySharedLinkSettingsError().withTag(Tag.SHARED_LINK_ACCESS_DENIED);
    public static final ModifySharedLinkSettingsError UNSUPPORTED_LINK_TYPE = new ModifySharedLinkSettingsError().withTag(Tag.UNSUPPORTED_LINK_TYPE);
    public static final ModifySharedLinkSettingsError OTHER = new ModifySharedLinkSettingsError().withTag(Tag.OTHER);
    public static final ModifySharedLinkSettingsError EMAIL_NOT_VERIFIED = new ModifySharedLinkSettingsError().withTag(Tag.EMAIL_NOT_VERIFIED);
    private Tag _tag;
    private SharedLinkSettingsError settingsErrorValue;

    private ModifySharedLinkSettingsError() {
    }

    private ModifySharedLinkSettingsError withTag(Tag _tag) {
        ModifySharedLinkSettingsError result = new ModifySharedLinkSettingsError();
        result._tag = _tag;
        return result;
    }

    private ModifySharedLinkSettingsError withTagAndSettingsError(Tag _tag, SharedLinkSettingsError settingsErrorValue) {
        ModifySharedLinkSettingsError result = new ModifySharedLinkSettingsError();
        result._tag = _tag;
        result.settingsErrorValue = settingsErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isSharedLinkNotFound() {
        return this._tag == Tag.SHARED_LINK_NOT_FOUND;
    }

    public boolean isSharedLinkAccessDenied() {
        return this._tag == Tag.SHARED_LINK_ACCESS_DENIED;
    }

    public boolean isUnsupportedLinkType() {
        return this._tag == Tag.UNSUPPORTED_LINK_TYPE;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isSettingsError() {
        return this._tag == Tag.SETTINGS_ERROR;
    }

    public static ModifySharedLinkSettingsError settingsError(SharedLinkSettingsError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ModifySharedLinkSettingsError().withTagAndSettingsError(Tag.SETTINGS_ERROR, value);
    }

    public SharedLinkSettingsError getSettingsErrorValue() {
        if (this._tag != Tag.SETTINGS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.SETTINGS_ERROR, but was Tag." + this._tag.name());
        }
        return this.settingsErrorValue;
    }

    public boolean isEmailNotVerified() {
        return this._tag == Tag.EMAIL_NOT_VERIFIED;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.settingsErrorValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ModifySharedLinkSettingsError) {
            ModifySharedLinkSettingsError other = (ModifySharedLinkSettingsError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case SHARED_LINK_NOT_FOUND: {
                    return true;
                }
                case SHARED_LINK_ACCESS_DENIED: {
                    return true;
                }
                case UNSUPPORTED_LINK_TYPE: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case SETTINGS_ERROR: {
                    return this.settingsErrorValue == other.settingsErrorValue || this.settingsErrorValue.equals((Object)other.settingsErrorValue);
                }
                case EMAIL_NOT_VERIFIED: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ModifySharedLinkSettingsError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ModifySharedLinkSettingsError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case SHARED_LINK_NOT_FOUND: {
                    g2.writeString("shared_link_not_found");
                    break;
                }
                case SHARED_LINK_ACCESS_DENIED: {
                    g2.writeString("shared_link_access_denied");
                    break;
                }
                case UNSUPPORTED_LINK_TYPE: {
                    g2.writeString("unsupported_link_type");
                    break;
                }
                case OTHER: {
                    g2.writeString("other");
                    break;
                }
                case SETTINGS_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("settings_error", g2);
                    g2.writeFieldName("settings_error");
                    SharedLinkSettingsError.Serializer.INSTANCE.serialize(value.settingsErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case EMAIL_NOT_VERIFIED: {
                    g2.writeString("email_not_verified");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public ModifySharedLinkSettingsError deserialize(JsonParser p) throws IOException, JsonParseException {
            ModifySharedLinkSettingsError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("shared_link_not_found".equals(tag)) {
                value = SHARED_LINK_NOT_FOUND;
            } else if ("shared_link_access_denied".equals(tag)) {
                value = SHARED_LINK_ACCESS_DENIED;
            } else if ("unsupported_link_type".equals(tag)) {
                value = UNSUPPORTED_LINK_TYPE;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("settings_error".equals(tag)) {
                SharedLinkSettingsError fieldValue = null;
                Serializer.expectField("settings_error", p);
                fieldValue = SharedLinkSettingsError.Serializer.INSTANCE.deserialize(p);
                value = ModifySharedLinkSettingsError.settingsError(fieldValue);
            } else if ("email_not_verified".equals(tag)) {
                value = EMAIL_NOT_VERIFIED;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        SHARED_LINK_NOT_FOUND,
        SHARED_LINK_ACCESS_DENIED,
        UNSUPPORTED_LINK_TYPE,
        OTHER,
        SETTINGS_ERROR,
        EMAIL_NOT_VERIFIED;

    }
}

