/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.dv8tion.jda.api.entities.Emoji;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.Button;
import net.dv8tion.jda.api.interactions.components.ButtonInteraction;
import net.dv8tion.jda.api.interactions.components.ButtonStyle;

public class SelectionMenu {
    private final List<Message> options = new ArrayList<Message>();
    private final List<Button> buttons = new ArrayList<Button>();
    private final long messageId;
    private final long userId;
    private int current = 0;

    public SelectionMenu(Message message) {
        this.messageId = message.getIdLong();
        this.userId = message.getAuthor().getIdLong();
    }

    public String getId() {
        return this.messageId + ":" + this.userId;
    }

    public Message getCurrent() {
        return this.options.get(this.current);
    }

    public SelectionMenu addOption(ButtonStyle style, String buttonText, Message page) {
        this.options.add(page);
        this.buttons.add(Button.of(style, this.getId() + ":" + this.buttons.size(), buttonText));
        return this;
    }

    public SelectionMenu addOption(ButtonStyle style, Emoji emoji, Message page) {
        this.options.add(page);
        this.buttons.add(Button.of(style, this.getId() + ":" + this.buttons.size(), emoji));
        return this;
    }

    public void onButtonClick(ButtonInteraction interaction) {
        if (interaction.getUser().getIdLong() != this.userId) {
            return;
        }
        String[] id = interaction.getComponentId().split(":");
        if (Long.parseUnsignedLong(id[0]) != this.messageId) {
            return;
        }
        try {
            int index = Integer.parseInt(id[2]);
            if (index < 0 || index >= this.options.size()) {
                return;
            }
            this.current = index;
            interaction.getHook().editOriginal(this.options.get(this.current)).setActionRows(this.getButtons()).queue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public ActionRow getButtons() {
        return ActionRow.of(IntStream.range(0, this.buttons.size()).mapToObj(i -> this.buttons.get(i).withDisabled(i == this.current)).collect(Collectors.toList()).toArray(new Button[this.buttons.size()]));
    }
}

