/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum PaperDocUpdateError {
    INSUFFICIENT_PERMISSIONS,
    OTHER,
    DOC_NOT_FOUND,
    CONTENT_MALFORMED,
    REVISION_MISMATCH,
    DOC_LENGTH_EXCEEDED,
    IMAGE_SIZE_EXCEEDED,
    DOC_ARCHIVED,
    DOC_DELETED;


    static class Serializer
    extends UnionSerializer<PaperDocUpdateError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperDocUpdateError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case INSUFFICIENT_PERMISSIONS: {
                    g2.writeString("insufficient_permissions");
                    break;
                }
                case OTHER: {
                    g2.writeString("other");
                    break;
                }
                case DOC_NOT_FOUND: {
                    g2.writeString("doc_not_found");
                    break;
                }
                case CONTENT_MALFORMED: {
                    g2.writeString("content_malformed");
                    break;
                }
                case REVISION_MISMATCH: {
                    g2.writeString("revision_mismatch");
                    break;
                }
                case DOC_LENGTH_EXCEEDED: {
                    g2.writeString("doc_length_exceeded");
                    break;
                }
                case IMAGE_SIZE_EXCEEDED: {
                    g2.writeString("image_size_exceeded");
                    break;
                }
                case DOC_ARCHIVED: {
                    g2.writeString("doc_archived");
                    break;
                }
                case DOC_DELETED: {
                    g2.writeString("doc_deleted");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value));
                }
            }
        }

        @Override
        public PaperDocUpdateError deserialize(JsonParser p) throws IOException, JsonParseException {
            PaperDocUpdateError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("insufficient_permissions".equals(tag)) {
                value = INSUFFICIENT_PERMISSIONS;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("doc_not_found".equals(tag)) {
                value = DOC_NOT_FOUND;
            } else if ("content_malformed".equals(tag)) {
                value = CONTENT_MALFORMED;
            } else if ("revision_mismatch".equals(tag)) {
                value = REVISION_MISMATCH;
            } else if ("doc_length_exceeded".equals(tag)) {
                value = DOC_LENGTH_EXCEEDED;
            } else if ("image_size_exceeded".equals(tag)) {
                value = IMAGE_SIZE_EXCEEDED;
            } else if ("doc_archived".equals(tag)) {
                value = DOC_ARCHIVED;
            } else if ("doc_deleted".equals(tag)) {
                value = DOC_DELETED;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

