/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class WriteMode {
    public static final WriteMode ADD = new WriteMode().withTag(Tag.ADD);
    public static final WriteMode OVERWRITE = new WriteMode().withTag(Tag.OVERWRITE);
    private Tag _tag;
    private String updateValue;

    private WriteMode() {
    }

    private WriteMode withTag(Tag _tag) {
        WriteMode result = new WriteMode();
        result._tag = _tag;
        return result;
    }

    private WriteMode withTagAndUpdate(Tag _tag, String updateValue) {
        WriteMode result = new WriteMode();
        result._tag = _tag;
        result.updateValue = updateValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAdd() {
        return this._tag == Tag.ADD;
    }

    public boolean isOverwrite() {
        return this._tag == Tag.OVERWRITE;
    }

    public boolean isUpdate() {
        return this._tag == Tag.UPDATE;
    }

    public static WriteMode update(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 9) {
            throw new IllegalArgumentException("String is shorter than 9");
        }
        if (!Pattern.matches("[0-9a-f]+", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new WriteMode().withTagAndUpdate(Tag.UPDATE, value);
    }

    public String getUpdateValue() {
        if (this._tag != Tag.UPDATE) {
            throw new IllegalStateException("Invalid tag: required Tag.UPDATE, but was Tag." + this._tag.name());
        }
        return this.updateValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.updateValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WriteMode) {
            WriteMode other = (WriteMode)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ADD: {
                    return true;
                }
                case OVERWRITE: {
                    return true;
                }
                case UPDATE: {
                    return this.updateValue == other.updateValue || this.updateValue.equals(other.updateValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<WriteMode> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(WriteMode value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ADD: {
                    g2.writeString("add");
                    break;
                }
                case OVERWRITE: {
                    g2.writeString("overwrite");
                    break;
                }
                case UPDATE: {
                    g2.writeStartObject();
                    this.writeTag("update", g2);
                    g2.writeFieldName("update");
                    StoneSerializers.string().serialize(value.updateValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public WriteMode deserialize(JsonParser p) throws IOException, JsonParseException {
            WriteMode value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("add".equals(tag)) {
                value = ADD;
            } else if ("overwrite".equals(tag)) {
                value = OVERWRITE;
            } else if ("update".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("update", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = WriteMode.update(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ADD,
        OVERWRITE,
        UPDATE;

    }
}

