/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.DeletedMetadata;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class Metadata {
    protected final String name;
    protected final String pathLower;
    protected final String pathDisplay;
    protected final String parentSharedFolderId;

    public Metadata(String name, String pathLower, String pathDisplay, String parentSharedFolderId) {
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        this.pathLower = pathLower;
        this.pathDisplay = pathDisplay;
        if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
    }

    public Metadata(String name) {
        this(name, null, null, null);
    }

    public String getName() {
        return this.name;
    }

    public String getPathLower() {
        return this.pathLower;
    }

    public String getPathDisplay() {
        return this.pathDisplay;
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.name, this.pathLower, this.pathDisplay, this.parentSharedFolderId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            Metadata other = (Metadata)obj;
            return (this.name == other.name || this.name.equals(other.name)) && (this.pathLower == other.pathLower || this.pathLower != null && this.pathLower.equals(other.pathLower)) && (this.pathDisplay == other.pathDisplay || this.pathDisplay != null && this.pathDisplay.equals(other.pathDisplay)) && (this.parentSharedFolderId == other.parentSharedFolderId || this.parentSharedFolderId != null && this.parentSharedFolderId.equals(other.parentSharedFolderId));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<Metadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(Metadata value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (value instanceof FileMetadata) {
                FileMetadata.Serializer.INSTANCE.serialize((FileMetadata)value, g2, collapse);
                return;
            }
            if (value instanceof FolderMetadata) {
                FolderMetadata.Serializer.INSTANCE.serialize((FolderMetadata)value, g2, collapse);
                return;
            }
            if (value instanceof DeletedMetadata) {
                DeletedMetadata.Serializer.INSTANCE.serialize((DeletedMetadata)value, g2, collapse);
                return;
            }
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g2);
            if (value.pathLower != null) {
                g2.writeFieldName("path_lower");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathLower, g2);
            }
            if (value.pathDisplay != null) {
                g2.writeFieldName("path_display");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathDisplay, g2);
            }
            if (value.parentSharedFolderId != null) {
                g2.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public Metadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Metadata value;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                String f_name = null;
                String f_pathLower = null;
                String f_pathDisplay = null;
                String f_parentSharedFolderId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("path_lower".equals(field)) {
                        f_pathLower = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_display".equals(field)) {
                        f_pathDisplay = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                value = new Metadata(f_name, f_pathLower, f_pathDisplay, f_parentSharedFolderId);
            } else if ("".equals(tag)) {
                value = INSTANCE.deserialize(p, true);
            } else if ("file".equals(tag)) {
                value = FileMetadata.Serializer.INSTANCE.deserialize(p, true);
            } else if ("folder".equals(tag)) {
                value = FolderMetadata.Serializer.INSTANCE.deserialize(p, true);
            } else if ("deleted".equals(tag)) {
                value = DeletedMetadata.Serializer.INSTANCE.deserialize(p, true);
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String name;
        protected String pathLower;
        protected String pathDisplay;
        protected String parentSharedFolderId;

        protected Builder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            this.pathLower = null;
            this.pathDisplay = null;
            this.parentSharedFolderId = null;
        }

        public Builder withPathLower(String pathLower) {
            this.pathLower = pathLower;
            return this;
        }

        public Builder withPathDisplay(String pathDisplay) {
            this.pathDisplay = pathDisplay;
            return this;
        }

        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
                throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
            }
            this.parentSharedFolderId = parentSharedFolderId;
            return this;
        }

        public Metadata build() {
            return new Metadata(this.name, this.pathLower, this.pathDisplay, this.parentSharedFolderId);
        }
    }
}

