/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.auth;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum RateLimitReason {
    TOO_MANY_REQUESTS,
    TOO_MANY_WRITE_OPERATIONS,
    OTHER;


    public static class Serializer
    extends UnionSerializer<RateLimitReason> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(RateLimitReason value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case TOO_MANY_REQUESTS: {
                    g2.writeString("too_many_requests");
                    break;
                }
                case TOO_MANY_WRITE_OPERATIONS: {
                    g2.writeString("too_many_write_operations");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public RateLimitReason deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            RateLimitReason value = "too_many_requests".equals(tag) ? TOO_MANY_REQUESTS : ("too_many_write_operations".equals(tag) ? TOO_MANY_WRITE_OPERATIONS : OTHER);
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

