/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class MembersInfo {
    protected final List<String> teamMemberIds;
    protected final long permanentlyDeletedUsers;

    public MembersInfo(List<String> teamMemberIds, long permanentlyDeletedUsers) {
        if (teamMemberIds == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberIds' is null");
        }
        for (String x : teamMemberIds) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'teamMemberIds' is null");
        }
        this.teamMemberIds = teamMemberIds;
        this.permanentlyDeletedUsers = permanentlyDeletedUsers;
    }

    public List<String> getTeamMemberIds() {
        return this.teamMemberIds;
    }

    public long getPermanentlyDeletedUsers() {
        return this.permanentlyDeletedUsers;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamMemberIds, this.permanentlyDeletedUsers});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MembersInfo other = (MembersInfo)obj;
            return (this.teamMemberIds == other.teamMemberIds || this.teamMemberIds.equals(other.teamMemberIds)) && this.permanentlyDeletedUsers == other.permanentlyDeletedUsers;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MembersInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("team_member_ids");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.teamMemberIds, g2);
            g2.writeFieldName("permanently_deleted_users");
            StoneSerializers.uInt64().serialize((Long)value.permanentlyDeletedUsers, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public MembersInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_permanentlyDeletedUsers;
            List<String> f_teamMemberIds;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamMemberIds = null;
                f_permanentlyDeletedUsers = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_member_ids".equals(field)) {
                        f_teamMemberIds = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("permanently_deleted_users".equals(field)) {
                        f_permanentlyDeletedUsers = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamMemberIds == null) {
                    throw new JsonParseException(p, "Required field \"team_member_ids\" missing.");
                }
                if (f_permanentlyDeletedUsers == null) {
                    throw new JsonParseException(p, "Required field \"permanently_deleted_users\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MembersInfo value = new MembersInfo(f_teamMemberIds, f_permanentlyDeletedUsers);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

