/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum GenericErrorTag {
    INVALID_ARGUMENT,
    UNAUTHENTICATED,
    PERMISSION_DENIED,
    DOC_NOT_FOUND,
    OTHER;


    static class Serializer
    extends UnionSerializer<GenericErrorTag> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GenericErrorTag value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case INVALID_ARGUMENT: {
                    g2.writeString("invalid_argument");
                    break;
                }
                case UNAUTHENTICATED: {
                    g2.writeString("unauthenticated");
                    break;
                }
                case PERMISSION_DENIED: {
                    g2.writeString("permission_denied");
                    break;
                }
                case DOC_NOT_FOUND: {
                    g2.writeString("doc_not_found");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public GenericErrorTag deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            GenericErrorTag value = "invalid_argument".equals(tag) ? INVALID_ARGUMENT : ("unauthenticated".equals(tag) ? UNAUTHENTICATED : ("permission_denied".equals(tag) ? PERMISSION_DENIED : ("doc_not_found".equals(tag) ? DOC_NOT_FOUND : OTHER)));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

