/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.NoThrowInputStream;
import com.dropbox.core.util.IOUtil;
import java.io.IOException;
import java.io.OutputStream;

public abstract class DbxStreamReader<E extends Throwable> {
    public abstract void read(NoThrowInputStream var1) throws E;

    public static final class ByteArrayCopier
    extends DbxStreamReader<RuntimeException> {
        private final byte[] data;
        private final int offset;
        private final int length;

        public ByteArrayCopier(byte[] data, int offset, int length) {
            if (data == null) {
                throw new IllegalArgumentException("'data' can't be null");
            }
            if (offset < 0 || offset >= data.length) {
                throw new IllegalArgumentException("'offset' is out of bounds");
            }
            if (offset + length < offset || offset + length > data.length) {
                throw new IllegalArgumentException("'offset+length' is out of bounds");
            }
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public ByteArrayCopier(byte[] data) {
            this(data, 0, data.length);
        }

        @Override
        public void read(NoThrowInputStream in) {
            in.read(this.data, this.offset, this.length);
        }
    }

    public static final class OutputStreamCopier
    extends DbxStreamReader<IOException> {
        private final OutputStream dest;

        public OutputStreamCopier(OutputStream dest) {
            this.dest = dest;
        }

        @Override
        public void read(NoThrowInputStream source) throws IOException {
            IOUtil.copyStreamToStream(source, this.dest);
        }
    }
}

