/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.util.gradle;

import com.almightyalpaca.discord.jdabutler.Bot;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;

public class GradleDownloader {
    public static final File GRADLE_DIR = new File("gradle-cache/");
    public static final String GRADLE_VERSION = "6.5";
    public static final File GRADLE_ZIP = new File(GRADLE_DIR, "gradle-6.5-bin.zip");
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    public static String getGradleDistributionURL() {
        return "https://services.gradle.org/distributions/gradle-6.5-bin.zip";
    }

    public static File getExecutableGradleFile() {
        if (!initialized.getAndSet(true)) {
            GradleDownloader.downloadGradle();
        }
        return new File(GRADLE_DIR, "/gradle-6.5/bin/gradle" + (SystemUtils.IS_OS_WINDOWS ? ".bat" : ""));
    }

    private static void downloadGradle() {
        if (GradleDownloader.getExecutableGradleFile().exists()) {
            return;
        }
        Bot.LOG.info("Downloading gradle...");
        try {
            if (GRADLE_ZIP.exists()) {
                GRADLE_ZIP.delete();
            } else {
                GRADLE_ZIP.getParentFile().mkdirs();
            }
            GRADLE_ZIP.createNewFile();
            FileUtils.copyURLToFile(new URL(GradleDownloader.getGradleDistributionURL()), GRADLE_ZIP);
            ZipFile zip = new ZipFile(GRADLE_ZIP);
            zip.extractAll(GRADLE_DIR.getAbsolutePath());
            GradleDownloader.getExecutableGradleFile().setExecutable(true);
            GRADLE_ZIP.delete();
        }
        catch (IOException e) {
            Bot.LOG.error("There was an error downloading/extracting gradle", e);
        }
    }
}

