/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.auth;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.auth.InvalidAccountTypeError;
import com.dropbox.core.v2.auth.PaperAccessError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class AccessError {
    public static final AccessError OTHER = new AccessError().withTag(Tag.OTHER);
    private Tag _tag;
    private InvalidAccountTypeError invalidAccountTypeValue;
    private PaperAccessError paperAccessDeniedValue;

    private AccessError() {
    }

    private AccessError withTag(Tag _tag) {
        AccessError result = new AccessError();
        result._tag = _tag;
        return result;
    }

    private AccessError withTagAndInvalidAccountType(Tag _tag, InvalidAccountTypeError invalidAccountTypeValue) {
        AccessError result = new AccessError();
        result._tag = _tag;
        result.invalidAccountTypeValue = invalidAccountTypeValue;
        return result;
    }

    private AccessError withTagAndPaperAccessDenied(Tag _tag, PaperAccessError paperAccessDeniedValue) {
        AccessError result = new AccessError();
        result._tag = _tag;
        result.paperAccessDeniedValue = paperAccessDeniedValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInvalidAccountType() {
        return this._tag == Tag.INVALID_ACCOUNT_TYPE;
    }

    public static AccessError invalidAccountType(InvalidAccountTypeError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AccessError().withTagAndInvalidAccountType(Tag.INVALID_ACCOUNT_TYPE, value);
    }

    public InvalidAccountTypeError getInvalidAccountTypeValue() {
        if (this._tag != Tag.INVALID_ACCOUNT_TYPE) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_ACCOUNT_TYPE, but was Tag." + this._tag.name());
        }
        return this.invalidAccountTypeValue;
    }

    public boolean isPaperAccessDenied() {
        return this._tag == Tag.PAPER_ACCESS_DENIED;
    }

    public static AccessError paperAccessDenied(PaperAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AccessError().withTagAndPaperAccessDenied(Tag.PAPER_ACCESS_DENIED, value);
    }

    public PaperAccessError getPaperAccessDeniedValue() {
        if (this._tag != Tag.PAPER_ACCESS_DENIED) {
            throw new IllegalStateException("Invalid tag: required Tag.PAPER_ACCESS_DENIED, but was Tag." + this._tag.name());
        }
        return this.paperAccessDeniedValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.invalidAccountTypeValue, this.paperAccessDeniedValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AccessError) {
            AccessError other = (AccessError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case INVALID_ACCOUNT_TYPE: {
                    return this.invalidAccountTypeValue == other.invalidAccountTypeValue || this.invalidAccountTypeValue.equals((Object)other.invalidAccountTypeValue);
                }
                case PAPER_ACCESS_DENIED: {
                    return this.paperAccessDeniedValue == other.paperAccessDeniedValue || this.paperAccessDeniedValue.equals((Object)other.paperAccessDeniedValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<AccessError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(AccessError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case INVALID_ACCOUNT_TYPE: {
                    g2.writeStartObject();
                    this.writeTag("invalid_account_type", g2);
                    g2.writeFieldName("invalid_account_type");
                    InvalidAccountTypeError.Serializer.INSTANCE.serialize(value.invalidAccountTypeValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case PAPER_ACCESS_DENIED: {
                    g2.writeStartObject();
                    this.writeTag("paper_access_denied", g2);
                    g2.writeFieldName("paper_access_denied");
                    PaperAccessError.Serializer.INSTANCE.serialize(value.paperAccessDeniedValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public AccessError deserialize(JsonParser p) throws IOException, JsonParseException {
            AccessError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("invalid_account_type".equals(tag)) {
                InvalidAccountTypeError fieldValue = null;
                Serializer.expectField("invalid_account_type", p);
                fieldValue = InvalidAccountTypeError.Serializer.INSTANCE.deserialize(p);
                value = AccessError.invalidAccountType(fieldValue);
            } else if ("paper_access_denied".equals(tag)) {
                PaperAccessError fieldValue = null;
                Serializer.expectField("paper_access_denied", p);
                fieldValue = PaperAccessError.Serializer.INSTANCE.deserialize(p);
                value = AccessError.paperAccessDenied(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        INVALID_ACCOUNT_TYPE,
        PAPER_ACCESS_DENIED,
        OTHER;

    }
}

