/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands;

import com.almightyalpaca.discord.jdabutler.commands.Command;
import com.almightyalpaca.discord.jdabutler.util.EmbedUtil;
import com.almightyalpaca.discord.jdabutler.util.gradle.GradleUtil;
import com.kantenkugel.discordbot.versioncheck.VersionCheckerRegistry;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class GradleCommand
extends Command {
    private static final String[] ALIASES = new String[]{"gradle.kts"};

    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        EmbedBuilder eb = new EmbedBuilder().setAuthor("Gradle dependencies", null, EmbedUtil.getJDAIconUrl());
        List<VersionedItem> items = VersionCheckerRegistry.getItemsFromString(content, true).stream().filter(item -> item.getGroupId() != null && item.getArtifactId() != null && item.getRepoType() != null).collect(Collectors.toList());
        boolean pretty = content.contains("pretty");
        boolean kotlin = message.getContentRaw().contains("gradle.kts");
        String lang = kotlin ? "kotlin" : "gradle";
        String description = String.format("If you don't know gradle type `!build.gradle%s` for a complete gradle build file", kotlin ? ".kts" : "") + "\n\n```" + lang + "\n" + GradleUtil.getDependencyBlock(kotlin, items, pretty) + "\n\n" + GradleUtil.getRepositoryBlock(kotlin, items) + "\n```";
        eb.setDescription(description);
        EmbedUtil.setColor(eb);
        this.reply(event, eb.build());
    }

    @Override
    public String getHelp() {
        return "Shows the gradle `compile ...` line";
    }

    @Override
    public String getName() {
        return "gradle";
    }

    @Override
    public String[] getAliases() {
        return ALIASES;
    }
}

