/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.commands.ButtonListener;
import com.almightyalpaca.discord.jdabutler.commands.ReactionCommand;
import com.almightyalpaca.discord.jdabutler.commands.ReactionListenerRegistry;
import com.almightyalpaca.discord.jdabutler.util.EmbedUtil;
import com.almightyalpaca.discord.jdabutler.util.Paginator;
import com.kantenkugel.discordbot.jdocparser.Documentation;
import com.kantenkugel.discordbot.jdocparser.JDoc;
import com.kantenkugel.discordbot.jdocparser.JDocUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.MessageBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class DocsCommand
extends ReactionCommand {
    private static final int RESULTS_PER_PAGE = 5;
    private static final String[] ALIASES = new String[]{"documentation", "doc", "jdoc", "jdocs"};
    private final ButtonListener buttons;

    public DocsCommand(ReactionListenerRegistry registry, ButtonListener buttons) {
        super(registry);
        this.buttons = buttons;
    }

    private static Message getDocMessage(String jDocBase, Documentation documentation) {
        EmbedBuilder embed = DocsCommand.getDefaultEmbed().setTitle(documentation.getTitle(), documentation.getUrl(jDocBase));
        Map<String, List<String>> fields = documentation.getFields();
        if (fields != null && fields.get("Deprecated:") != null) {
            embed.setColor(Color.RED);
        } else if (fields != null && fields.get("Incubating") != null) {
            embed.setColor(Color.orange);
        }
        if (documentation.getContent().length() > 2048) {
            embed.appendDescription("Description too long. Please refer to [the online docs](" + documentation.getUrl(jDocBase) + ')');
            return new MessageBuilder().setEmbed(embed.build()).build();
        }
        if (documentation.getContent().length() == 0) {
            embed.appendDescription("No Description available.");
        } else {
            embed.appendDescription(documentation.getContent());
        }
        if (fields != null && fields.size() > 0) {
            for (Map.Entry<String, List<String>> field : fields.entrySet()) {
                String fieldValue = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)field.getValue());
                if (fieldValue.length() > 1024) {
                    embed.addField(field.getKey(), "This section is too long. Please look at [the online docs](" + documentation.getUrl(jDocBase) + ')', false);
                    continue;
                }
                embed.addField(field.getKey(), String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)field.getValue()), false);
            }
        }
        return new MessageBuilder().setEmbed(embed.build()).build();
    }

    private void showPaginatorEmbed(GuildMessageReceivedEvent event, String jDocBase, Set<Documentation> items) {
        Paginator paginator = new Paginator(event.getMessage());
        this.buttons.addListener(paginator.getId(), paginator::onButtonClick);
        List<Documentation> sorted = items.stream().sorted(Comparator.comparing(Documentation::getShortTitle)).collect(Collectors.toList());
        for (int i = 0; i <= (sorted.size() - 1) / 5; ++i) {
            paginator.addPage(DocsCommand.getMultiResult(jDocBase, sorted, i));
        }
        event.getMessage().reply(paginator.getCurrent()).setActionRows(paginator.getButtons()).mentionRepliedUser(false).queue(this.linkReply(event, null));
    }

    private void showRefinementEmbed(GuildMessageReceivedEvent event, User sender, String jDocBase, List<Documentation> docs) {
        EmbedBuilder embedB = DocsCommand.getDefaultEmbed().setTitle("Refine your Search");
        for (int i = 0; i < docs.size(); ++i) {
            Documentation doc = docs.get(i);
            embedB.appendDescription(ReactionCommand.NUMBERS[i] + " [" + doc.getShortTitle() + "](" + doc.getUrl(jDocBase) + ")\n");
        }
        embedB.getDescriptionBuilder().setLength(embedB.getDescriptionBuilder().length() - 1);
        List options = Arrays.stream(ReactionCommand.NUMBERS).limit(docs.size()).collect(Collectors.toList());
        options.add("\u274c");
        this.reply(event, embedB.build(), (Message m3) -> this.addReactions((Message)m3, options, Collections.singleton(sender), 30, TimeUnit.SECONDS, index -> {
            if (index >= docs.size()) {
                this.stopReactions((Message)m3, false);
                m3.delete().queue();
                return;
            }
            this.stopReactions((Message)m3);
            m3.editMessage(DocsCommand.getDocMessage(jDocBase, (Documentation)docs.get((int)index))).queue();
        }));
    }

    private static Message getMultiResult(String jDocBase, List<Documentation> search, int page) {
        EmbedBuilder embed = DocsCommand.getDefaultEmbed().setTitle("Found " + search.size() + " Results. Page " + (page + 1) + '/' + ((search.size() - 1) / 5 + 1));
        for (int index = page * 5; index < search.size() && index < (page + 1) * 5; ++index) {
            Documentation documentation = search.get(index);
            embed.appendDescription('[' + documentation.getShortTitle() + "](" + documentation.getUrl(jDocBase) + ")\n");
        }
        return new MessageBuilder().setEmbed(embed.build()).build();
    }

    private static EmbedBuilder getDefaultEmbed() {
        return new EmbedBuilder().setAuthor("JDA Javadocs", null, EmbedUtil.getJDAIconUrl()).setColor(EmbedUtil.COLOR_JDA_PURPLE);
    }

    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        if (content.trim().isEmpty()) {
            this.reply(event, "See the docs here: " + JDocUtil.JDOCBASE);
            return;
        }
        if (content.trim().equalsIgnoreCase("help")) {
            String cmd = Bot.config.getString("prefix") + "docs";
            this.reply(event, "Searches and prints out documentation.\nSyntax: `" + cmd + " [term | search:[params:]term | java:term | help]`.\n\n**Standard Mode**\nWhen in `standard` mode, `term` is a class name or a class-prefixed variable or method name. Both `.` and `#` can be used to specify inner classes, methods and variables. Omitting the method parentheses will print all available methods with given name. When specified (with parameter types), only the specific one is returned.\n\n__Examples__:\n`" + cmd + " JDA#getUserById`\n`" + cmd + " TextChannel.sendMessage`\n`" + cmd + " TextChannel.sendMessage(Message)`\n\n**Search Mode**\nWhen in `search` mode, `.` and `#` won't work and all documentations that **contain** `term` in their name/signature are returned.\nSearch parameters can be used to restrict the search:\n   `f  ` - to only search for methods\n   `var` - to only search for variables\n   `c  ` - to only search for classes\n   `cs ` - to make matching case-sensitive\n\n__Examples__:\n`" + cmd + " search:onGuildMember`\n`" + cmd + " search:c:join`\n`" + cmd + " search:f:getTextChannel`\n\n**Java JDK Mode**\nWhen in `java` mode, java 8 docs are searched instead. Syntax for `term` is the same as `standard` mode.\n\n__Examples__:\n`" + cmd + " java:BufferedInputStream`\n`" + cmd + " java:List.get`\n");
            return;
        }
        if (content.contains(":")) {
            String[] split = content.split(":", 4);
            if (split.length > 3) {
                this.reply(event, "Invalid syntax!");
                return;
            }
            block4 : switch (split[0].toLowerCase()) {
                case "search": {
                    String[] options = split.length == 3 ? split[1].toLowerCase().split("\\s*,\\s*") : new String[]{};
                    Set<Documentation> search = JDoc.search(split[split.length - 1], options);
                    if (search.size() == 0) {
                        this.reply(event, "Did not find anything matching query!");
                        return;
                    }
                    if (search.size() > 5) {
                        this.showPaginatorEmbed(event, JDocUtil.JDOCBASE, search);
                        break;
                    }
                    EmbedBuilder embedB = DocsCommand.getDefaultEmbed().setTitle("Found following:");
                    for (Documentation documentation : search) {
                        embedB.appendDescription('[' + documentation.getShortTitle() + "](" + documentation.getUrl(JDocUtil.JDOCBASE) + ")\n");
                    }
                    embedB.getDescriptionBuilder().setLength(embedB.getDescriptionBuilder().length() - 1);
                    this.reply(event, embedB.build());
                    break;
                }
                case "java": {
                    if (split.length != 2) {
                        this.reply(event, "Invalid syntax!");
                        return;
                    }
                    List<Documentation> javadocs = JDoc.getJava(split[1]);
                    switch (javadocs.size()) {
                        case 0: {
                            this.reply(event, "No Result found!");
                            break block4;
                        }
                        case 1: {
                            this.reply(event, DocsCommand.getDocMessage("https://docs.oracle.com/javase/8/docs/api/", javadocs.get(0)));
                            break block4;
                        }
                    }
                    this.showRefinementEmbed(event, sender, "https://docs.oracle.com/javase/8/docs/api/", javadocs);
                    break;
                }
                default: {
                    this.reply(event, "Unsupported operation " + split[0]);
                }
            }
            return;
        }
        List<Documentation> docs = JDoc.get(content);
        switch (docs.size()) {
            case 0: {
                this.reply(event, "No Result found!");
                break;
            }
            case 1: {
                this.reply(event, DocsCommand.getDocMessage(JDocUtil.JDOCBASE, docs.get(0)));
                break;
            }
            default: {
                this.showRefinementEmbed(event, sender, JDocUtil.JDOCBASE, docs);
            }
        }
    }

    @Override
    public String getHelp() {
        return "Displays documentation. Use `" + Bot.config.getString("prefix") + "docs help` for more help";
    }

    @Override
    public String getName() {
        return "docs";
    }

    @Override
    public String[] getAliases() {
        return ALIASES;
    }
}

