/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SaveUrlError {
    public static final SaveUrlError DOWNLOAD_FAILED = new SaveUrlError().withTag(Tag.DOWNLOAD_FAILED);
    public static final SaveUrlError INVALID_URL = new SaveUrlError().withTag(Tag.INVALID_URL);
    public static final SaveUrlError NOT_FOUND = new SaveUrlError().withTag(Tag.NOT_FOUND);
    public static final SaveUrlError OTHER = new SaveUrlError().withTag(Tag.OTHER);
    private Tag _tag;
    private WriteError pathValue;

    private SaveUrlError() {
    }

    private SaveUrlError withTag(Tag _tag) {
        SaveUrlError result = new SaveUrlError();
        result._tag = _tag;
        return result;
    }

    private SaveUrlError withTagAndPath(Tag _tag, WriteError pathValue) {
        SaveUrlError result = new SaveUrlError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static SaveUrlError path(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SaveUrlError().withTagAndPath(Tag.PATH, value);
    }

    public WriteError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isDownloadFailed() {
        return this._tag == Tag.DOWNLOAD_FAILED;
    }

    public boolean isInvalidUrl() {
        return this._tag == Tag.INVALID_URL;
    }

    public boolean isNotFound() {
        return this._tag == Tag.NOT_FOUND;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SaveUrlError) {
            SaveUrlError other = (SaveUrlError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case DOWNLOAD_FAILED: {
                    return true;
                }
                case INVALID_URL: {
                    return true;
                }
                case NOT_FOUND: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SaveUrlError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SaveUrlError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g2.writeStartObject();
                    this.writeTag("path", g2);
                    g2.writeFieldName("path");
                    WriteError.Serializer.INSTANCE.serialize(value.pathValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case DOWNLOAD_FAILED: {
                    g2.writeString("download_failed");
                    break;
                }
                case INVALID_URL: {
                    g2.writeString("invalid_url");
                    break;
                }
                case NOT_FOUND: {
                    g2.writeString("not_found");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public SaveUrlError deserialize(JsonParser p) throws IOException, JsonParseException {
            SaveUrlError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                WriteError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = WriteError.Serializer.INSTANCE.deserialize(p);
                value = SaveUrlError.path(fieldValue);
            } else {
                value = "download_failed".equals(tag) ? DOWNLOAD_FAILED : ("invalid_url".equals(tag) ? INVALID_URL : ("not_found".equals(tag) ? NOT_FOUND : OTHER));
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        DOWNLOAD_FAILED,
        INVALID_URL,
        NOT_FOUND,
        OTHER;

    }
}

