/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.contacts;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public final class DeleteManualContactsError {
    public static final DeleteManualContactsError OTHER = new DeleteManualContactsError().withTag(Tag.OTHER);
    private Tag _tag;
    private List<String> contactsNotFoundValue;

    private DeleteManualContactsError() {
    }

    private DeleteManualContactsError withTag(Tag _tag) {
        DeleteManualContactsError result = new DeleteManualContactsError();
        result._tag = _tag;
        return result;
    }

    private DeleteManualContactsError withTagAndContactsNotFound(Tag _tag, List<String> contactsNotFoundValue) {
        DeleteManualContactsError result = new DeleteManualContactsError();
        result._tag = _tag;
        result.contactsNotFoundValue = contactsNotFoundValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isContactsNotFound() {
        return this._tag == Tag.CONTACTS_NOT_FOUND;
    }

    public static DeleteManualContactsError contactsNotFound(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list is null");
            }
            if (x.length() > 255) {
                throw new IllegalArgumentException("Stringan item in list is longer than 255");
            }
            if (Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", x)) continue;
            throw new IllegalArgumentException("Stringan item in list does not match pattern");
        }
        return new DeleteManualContactsError().withTagAndContactsNotFound(Tag.CONTACTS_NOT_FOUND, value);
    }

    public List<String> getContactsNotFoundValue() {
        if (this._tag != Tag.CONTACTS_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.CONTACTS_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.contactsNotFoundValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.contactsNotFoundValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DeleteManualContactsError) {
            DeleteManualContactsError other = (DeleteManualContactsError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case CONTACTS_NOT_FOUND: {
                    return this.contactsNotFoundValue == other.contactsNotFoundValue || this.contactsNotFoundValue.equals(other.contactsNotFoundValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<DeleteManualContactsError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeleteManualContactsError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case CONTACTS_NOT_FOUND: {
                    g2.writeStartObject();
                    this.writeTag("contacts_not_found", g2);
                    g2.writeFieldName("contacts_not_found");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.contactsNotFoundValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public DeleteManualContactsError deserialize(JsonParser p) throws IOException, JsonParseException {
            DeleteManualContactsError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("contacts_not_found".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("contacts_not_found", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = DeleteManualContactsError.contactsNotFound(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        CONTACTS_NOT_FOUND,
        OTHER;

    }
}

