/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.TfaConfiguration;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class TfaChangeStatusDetails {
    protected final TfaConfiguration newValue;
    protected final TfaConfiguration previousValue;
    protected final Boolean usedRescueCode;

    public TfaChangeStatusDetails(TfaConfiguration newValue, TfaConfiguration previousValue, Boolean usedRescueCode) {
        if (newValue == null) {
            throw new IllegalArgumentException("Required value for 'newValue' is null");
        }
        this.newValue = newValue;
        this.previousValue = previousValue;
        this.usedRescueCode = usedRescueCode;
    }

    public TfaChangeStatusDetails(TfaConfiguration newValue) {
        this(newValue, null, null);
    }

    public TfaConfiguration getNewValue() {
        return this.newValue;
    }

    public TfaConfiguration getPreviousValue() {
        return this.previousValue;
    }

    public Boolean getUsedRescueCode() {
        return this.usedRescueCode;
    }

    public static Builder newBuilder(TfaConfiguration newValue) {
        return new Builder(newValue);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.newValue, this.previousValue, this.usedRescueCode});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TfaChangeStatusDetails other = (TfaChangeStatusDetails)obj;
            return (this.newValue == other.newValue || this.newValue.equals((Object)other.newValue)) && (this.previousValue == other.previousValue || this.previousValue != null && this.previousValue.equals((Object)other.previousValue)) && (this.usedRescueCode == other.usedRescueCode || this.usedRescueCode != null && this.usedRescueCode.equals(other.usedRescueCode));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TfaChangeStatusDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TfaChangeStatusDetails value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("new_value");
            TfaConfiguration.Serializer.INSTANCE.serialize(value.newValue, g2);
            if (value.previousValue != null) {
                g2.writeFieldName("previous_value");
                StoneSerializers.nullable(TfaConfiguration.Serializer.INSTANCE).serialize(value.previousValue, g2);
            }
            if (value.usedRescueCode != null) {
                g2.writeFieldName("used_rescue_code");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.usedRescueCode, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public TfaChangeStatusDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_usedRescueCode;
            TfaConfiguration f_previousValue;
            TfaConfiguration f_newValue;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_newValue = null;
                f_previousValue = null;
                f_usedRescueCode = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("new_value".equals(field)) {
                        f_newValue = TfaConfiguration.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("previous_value".equals(field)) {
                        f_previousValue = StoneSerializers.nullable(TfaConfiguration.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("used_rescue_code".equals(field)) {
                        f_usedRescueCode = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_newValue == null) {
                    throw new JsonParseException(p, "Required field \"new_value\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TfaChangeStatusDetails value = new TfaChangeStatusDetails(f_newValue, f_previousValue, f_usedRescueCode);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final TfaConfiguration newValue;
        protected TfaConfiguration previousValue;
        protected Boolean usedRescueCode;

        protected Builder(TfaConfiguration newValue) {
            if (newValue == null) {
                throw new IllegalArgumentException("Required value for 'newValue' is null");
            }
            this.newValue = newValue;
            this.previousValue = null;
            this.usedRescueCode = null;
        }

        public Builder withPreviousValue(TfaConfiguration previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        public Builder withUsedRescueCode(Boolean usedRescueCode) {
            this.usedRescueCode = usedRescueCode;
            return this;
        }

        public TfaChangeStatusDetails build() {
            return new TfaChangeStatusDetails(this.newValue, this.previousValue, this.usedRescueCode);
        }
    }
}

