/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.UserSecondaryEmailsResult;
import com.dropbox.core.v2.team.UserSelectorArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UserAddResult {
    public static final UserAddResult OTHER = new UserAddResult().withTag(Tag.OTHER);
    private Tag _tag;
    private UserSecondaryEmailsResult successValue;
    private UserSelectorArg invalidUserValue;
    private UserSelectorArg unverifiedValue;
    private UserSelectorArg placeholderUserValue;

    private UserAddResult() {
    }

    private UserAddResult withTag(Tag _tag) {
        UserAddResult result = new UserAddResult();
        result._tag = _tag;
        return result;
    }

    private UserAddResult withTagAndSuccess(Tag _tag, UserSecondaryEmailsResult successValue) {
        UserAddResult result = new UserAddResult();
        result._tag = _tag;
        result.successValue = successValue;
        return result;
    }

    private UserAddResult withTagAndInvalidUser(Tag _tag, UserSelectorArg invalidUserValue) {
        UserAddResult result = new UserAddResult();
        result._tag = _tag;
        result.invalidUserValue = invalidUserValue;
        return result;
    }

    private UserAddResult withTagAndUnverified(Tag _tag, UserSelectorArg unverifiedValue) {
        UserAddResult result = new UserAddResult();
        result._tag = _tag;
        result.unverifiedValue = unverifiedValue;
        return result;
    }

    private UserAddResult withTagAndPlaceholderUser(Tag _tag, UserSelectorArg placeholderUserValue) {
        UserAddResult result = new UserAddResult();
        result._tag = _tag;
        result.placeholderUserValue = placeholderUserValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isSuccess() {
        return this._tag == Tag.SUCCESS;
    }

    public static UserAddResult success(UserSecondaryEmailsResult value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserAddResult().withTagAndSuccess(Tag.SUCCESS, value);
    }

    public UserSecondaryEmailsResult getSuccessValue() {
        if (this._tag != Tag.SUCCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.SUCCESS, but was Tag." + this._tag.name());
        }
        return this.successValue;
    }

    public boolean isInvalidUser() {
        return this._tag == Tag.INVALID_USER;
    }

    public static UserAddResult invalidUser(UserSelectorArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserAddResult().withTagAndInvalidUser(Tag.INVALID_USER, value);
    }

    public UserSelectorArg getInvalidUserValue() {
        if (this._tag != Tag.INVALID_USER) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_USER, but was Tag." + this._tag.name());
        }
        return this.invalidUserValue;
    }

    public boolean isUnverified() {
        return this._tag == Tag.UNVERIFIED;
    }

    public static UserAddResult unverified(UserSelectorArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserAddResult().withTagAndUnverified(Tag.UNVERIFIED, value);
    }

    public UserSelectorArg getUnverifiedValue() {
        if (this._tag != Tag.UNVERIFIED) {
            throw new IllegalStateException("Invalid tag: required Tag.UNVERIFIED, but was Tag." + this._tag.name());
        }
        return this.unverifiedValue;
    }

    public boolean isPlaceholderUser() {
        return this._tag == Tag.PLACEHOLDER_USER;
    }

    public static UserAddResult placeholderUser(UserSelectorArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserAddResult().withTagAndPlaceholderUser(Tag.PLACEHOLDER_USER, value);
    }

    public UserSelectorArg getPlaceholderUserValue() {
        if (this._tag != Tag.PLACEHOLDER_USER) {
            throw new IllegalStateException("Invalid tag: required Tag.PLACEHOLDER_USER, but was Tag." + this._tag.name());
        }
        return this.placeholderUserValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.successValue, this.invalidUserValue, this.unverifiedValue, this.placeholderUserValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UserAddResult) {
            UserAddResult other = (UserAddResult)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case SUCCESS: {
                    return this.successValue == other.successValue || this.successValue.equals(other.successValue);
                }
                case INVALID_USER: {
                    return this.invalidUserValue == other.invalidUserValue || this.invalidUserValue.equals(other.invalidUserValue);
                }
                case UNVERIFIED: {
                    return this.unverifiedValue == other.unverifiedValue || this.unverifiedValue.equals(other.unverifiedValue);
                }
                case PLACEHOLDER_USER: {
                    return this.placeholderUserValue == other.placeholderUserValue || this.placeholderUserValue.equals(other.placeholderUserValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UserAddResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserAddResult value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case SUCCESS: {
                    g2.writeStartObject();
                    this.writeTag("success", g2);
                    UserSecondaryEmailsResult.Serializer.INSTANCE.serialize(value.successValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                case INVALID_USER: {
                    g2.writeStartObject();
                    this.writeTag("invalid_user", g2);
                    g2.writeFieldName("invalid_user");
                    UserSelectorArg.Serializer.INSTANCE.serialize(value.invalidUserValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case UNVERIFIED: {
                    g2.writeStartObject();
                    this.writeTag("unverified", g2);
                    g2.writeFieldName("unverified");
                    UserSelectorArg.Serializer.INSTANCE.serialize(value.unverifiedValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case PLACEHOLDER_USER: {
                    g2.writeStartObject();
                    this.writeTag("placeholder_user", g2);
                    g2.writeFieldName("placeholder_user");
                    UserSelectorArg.Serializer.INSTANCE.serialize(value.placeholderUserValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public UserAddResult deserialize(JsonParser p) throws IOException, JsonParseException {
            UserAddResult value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("success".equals(tag)) {
                UserSecondaryEmailsResult fieldValue = null;
                fieldValue = UserSecondaryEmailsResult.Serializer.INSTANCE.deserialize(p, true);
                value = UserAddResult.success(fieldValue);
            } else if ("invalid_user".equals(tag)) {
                UserSelectorArg fieldValue = null;
                Serializer.expectField("invalid_user", p);
                fieldValue = UserSelectorArg.Serializer.INSTANCE.deserialize(p);
                value = UserAddResult.invalidUser(fieldValue);
            } else if ("unverified".equals(tag)) {
                UserSelectorArg fieldValue = null;
                Serializer.expectField("unverified", p);
                fieldValue = UserSelectorArg.Serializer.INSTANCE.deserialize(p);
                value = UserAddResult.unverified(fieldValue);
            } else if ("placeholder_user".equals(tag)) {
                UserSelectorArg fieldValue = null;
                Serializer.expectField("placeholder_user", p);
                fieldValue = UserSelectorArg.Serializer.INSTANCE.deserialize(p);
                value = UserAddResult.placeholderUser(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        SUCCESS,
        INVALID_USER,
        UNVERIFIED,
        PLACEHOLDER_USER,
        OTHER;

    }
}

