/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.RemovedStatus;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class TeamMemberStatus {
    public static final TeamMemberStatus ACTIVE = new TeamMemberStatus().withTag(Tag.ACTIVE);
    public static final TeamMemberStatus INVITED = new TeamMemberStatus().withTag(Tag.INVITED);
    public static final TeamMemberStatus SUSPENDED = new TeamMemberStatus().withTag(Tag.SUSPENDED);
    private Tag _tag;
    private RemovedStatus removedValue;

    private TeamMemberStatus() {
    }

    private TeamMemberStatus withTag(Tag _tag) {
        TeamMemberStatus result = new TeamMemberStatus();
        result._tag = _tag;
        return result;
    }

    private TeamMemberStatus withTagAndRemoved(Tag _tag, RemovedStatus removedValue) {
        TeamMemberStatus result = new TeamMemberStatus();
        result._tag = _tag;
        result.removedValue = removedValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isActive() {
        return this._tag == Tag.ACTIVE;
    }

    public boolean isInvited() {
        return this._tag == Tag.INVITED;
    }

    public boolean isSuspended() {
        return this._tag == Tag.SUSPENDED;
    }

    public boolean isRemoved() {
        return this._tag == Tag.REMOVED;
    }

    public static TeamMemberStatus removed(RemovedStatus value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TeamMemberStatus().withTagAndRemoved(Tag.REMOVED, value);
    }

    public RemovedStatus getRemovedValue() {
        if (this._tag != Tag.REMOVED) {
            throw new IllegalStateException("Invalid tag: required Tag.REMOVED, but was Tag." + this._tag.name());
        }
        return this.removedValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.removedValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TeamMemberStatus) {
            TeamMemberStatus other = (TeamMemberStatus)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ACTIVE: {
                    return true;
                }
                case INVITED: {
                    return true;
                }
                case SUSPENDED: {
                    return true;
                }
                case REMOVED: {
                    return this.removedValue == other.removedValue || this.removedValue.equals(other.removedValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<TeamMemberStatus> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamMemberStatus value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ACTIVE: {
                    g2.writeString("active");
                    break;
                }
                case INVITED: {
                    g2.writeString("invited");
                    break;
                }
                case SUSPENDED: {
                    g2.writeString("suspended");
                    break;
                }
                case REMOVED: {
                    g2.writeStartObject();
                    this.writeTag("removed", g2);
                    RemovedStatus.Serializer.INSTANCE.serialize(value.removedValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public TeamMemberStatus deserialize(JsonParser p) throws IOException, JsonParseException {
            TeamMemberStatus value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("active".equals(tag)) {
                value = ACTIVE;
            } else if ("invited".equals(tag)) {
                value = INVITED;
            } else if ("suspended".equals(tag)) {
                value = SUSPENDED;
            } else if ("removed".equals(tag)) {
                RemovedStatus fieldValue = null;
                fieldValue = RemovedStatus.Serializer.INSTANCE.deserialize(p, true);
                value = TeamMemberStatus.removed(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ACTIVE,
        INVITED,
        SUSPENDED,
        REMOVED;

    }
}

