/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.NamespaceType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class NamespaceMetadata {
    protected final String name;
    protected final String namespaceId;
    protected final NamespaceType namespaceType;
    protected final String teamMemberId;

    public NamespaceMetadata(String name, String namespaceId, NamespaceType namespaceType, String teamMemberId) {
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (namespaceId == null) {
            throw new IllegalArgumentException("Required value for 'namespaceId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", namespaceId)) {
            throw new IllegalArgumentException("String 'namespaceId' does not match pattern");
        }
        this.namespaceId = namespaceId;
        if (namespaceType == null) {
            throw new IllegalArgumentException("Required value for 'namespaceType' is null");
        }
        this.namespaceType = namespaceType;
        this.teamMemberId = teamMemberId;
    }

    public NamespaceMetadata(String name, String namespaceId, NamespaceType namespaceType) {
        this(name, namespaceId, namespaceType, null);
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public NamespaceType getNamespaceType() {
        return this.namespaceType;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.name, this.namespaceId, this.namespaceType, this.teamMemberId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            NamespaceMetadata other = (NamespaceMetadata)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.namespaceId != other.namespaceId && !this.namespaceId.equals(other.namespaceId) || this.namespaceType != other.namespaceType && !this.namespaceType.equals((Object)other.namespaceType) || this.teamMemberId != other.teamMemberId && (this.teamMemberId == null || !this.teamMemberId.equals(other.teamMemberId)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<NamespaceMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(NamespaceMetadata value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g2);
            g2.writeFieldName("namespace_id");
            StoneSerializers.string().serialize(value.namespaceId, g2);
            g2.writeFieldName("namespace_type");
            NamespaceType.Serializer.INSTANCE.serialize(value.namespaceType, g2);
            if (value.teamMemberId != null) {
                g2.writeFieldName("team_member_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.teamMemberId, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public NamespaceMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_teamMemberId;
            NamespaceType f_namespaceType;
            String f_namespaceId;
            String f_name;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_name = null;
                f_namespaceId = null;
                f_namespaceType = null;
                f_teamMemberId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("namespace_id".equals(field)) {
                        f_namespaceId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("namespace_type".equals(field)) {
                        f_namespaceType = NamespaceType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_namespaceId == null) {
                    throw new JsonParseException(p, "Required field \"namespace_id\" missing.");
                }
                if (f_namespaceType == null) {
                    throw new JsonParseException(p, "Required field \"namespace_type\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            NamespaceMetadata value = new NamespaceMetadata(f_name, f_namespaceId, f_namespaceType, f_teamMemberId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

