/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.GroupMemberInfo;
import com.dropbox.core.v2.teamcommon.GroupManagementType;
import com.dropbox.core.v2.teamcommon.GroupSummary;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class GroupFullInfo
extends GroupSummary {
    protected final List<GroupMemberInfo> members;
    protected final long created;

    public GroupFullInfo(String groupName, String groupId, GroupManagementType groupManagementType, long created, String groupExternalId, Long memberCount, List<GroupMemberInfo> members) {
        super(groupName, groupId, groupManagementType, groupExternalId, memberCount);
        if (members != null) {
            for (GroupMemberInfo x : members) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'members' is null");
            }
        }
        this.members = members;
        this.created = created;
    }

    public GroupFullInfo(String groupName, String groupId, GroupManagementType groupManagementType, long created) {
        this(groupName, groupId, groupManagementType, created, null, null, null);
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public GroupManagementType getGroupManagementType() {
        return this.groupManagementType;
    }

    public long getCreated() {
        return this.created;
    }

    @Override
    public String getGroupExternalId() {
        return this.groupExternalId;
    }

    @Override
    public Long getMemberCount() {
        return this.memberCount;
    }

    public List<GroupMemberInfo> getMembers() {
        return this.members;
    }

    public static Builder newBuilder(String groupName, String groupId, GroupManagementType groupManagementType, long created) {
        return new Builder(groupName, groupId, groupManagementType, created);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.members, this.created});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupFullInfo other = (GroupFullInfo)obj;
            return !(this.groupName != other.groupName && !this.groupName.equals(other.groupName) || this.groupId != other.groupId && !this.groupId.equals(other.groupId) || this.groupManagementType != other.groupManagementType && !this.groupManagementType.equals((Object)other.groupManagementType) || this.created != other.created || this.groupExternalId != other.groupExternalId && (this.groupExternalId == null || !this.groupExternalId.equals(other.groupExternalId)) || this.memberCount != other.memberCount && (this.memberCount == null || !this.memberCount.equals(other.memberCount)) || this.members != other.members && (this.members == null || !this.members.equals(other.members)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupFullInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupFullInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("group_name");
            StoneSerializers.string().serialize(value.groupName, g2);
            g2.writeFieldName("group_id");
            StoneSerializers.string().serialize(value.groupId, g2);
            g2.writeFieldName("group_management_type");
            GroupManagementType.Serializer.INSTANCE.serialize(value.groupManagementType, g2);
            g2.writeFieldName("created");
            StoneSerializers.uInt64().serialize((Long)value.created, g2);
            if (value.groupExternalId != null) {
                g2.writeFieldName("group_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.groupExternalId, g2);
            }
            if (value.memberCount != null) {
                g2.writeFieldName("member_count");
                StoneSerializers.nullable(StoneSerializers.uInt32()).serialize(value.memberCount, g2);
            }
            if (value.members != null) {
                g2.writeFieldName("members");
                StoneSerializers.nullable(StoneSerializers.list(GroupMemberInfo.Serializer.INSTANCE)).serialize(value.members, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public GroupFullInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<GroupMemberInfo> f_members;
            Long f_memberCount;
            String f_groupExternalId;
            Long f_created;
            GroupManagementType f_groupManagementType;
            String f_groupId;
            String f_groupName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_groupName = null;
                f_groupId = null;
                f_groupManagementType = null;
                f_created = null;
                f_groupExternalId = null;
                f_memberCount = null;
                f_members = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("group_name".equals(field)) {
                        f_groupName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("group_id".equals(field)) {
                        f_groupId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("group_management_type".equals(field)) {
                        f_groupManagementType = GroupManagementType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("created".equals(field)) {
                        f_created = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("group_external_id".equals(field)) {
                        f_groupExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_count".equals(field)) {
                        f_memberCount = StoneSerializers.nullable(StoneSerializers.uInt32()).deserialize(p);
                        continue;
                    }
                    if ("members".equals(field)) {
                        f_members = StoneSerializers.nullable(StoneSerializers.list(GroupMemberInfo.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_groupName == null) {
                    throw new JsonParseException(p, "Required field \"group_name\" missing.");
                }
                if (f_groupId == null) {
                    throw new JsonParseException(p, "Required field \"group_id\" missing.");
                }
                if (f_groupManagementType == null) {
                    throw new JsonParseException(p, "Required field \"group_management_type\" missing.");
                }
                if (f_created == null) {
                    throw new JsonParseException(p, "Required field \"created\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupFullInfo value = new GroupFullInfo(f_groupName, f_groupId, f_groupManagementType, f_created, f_groupExternalId, f_memberCount, f_members);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends GroupSummary.Builder {
        protected final long created;
        protected List<GroupMemberInfo> members;

        protected Builder(String groupName, String groupId, GroupManagementType groupManagementType, long created) {
            super(groupName, groupId, groupManagementType);
            this.created = created;
            this.members = null;
        }

        public Builder withMembers(List<GroupMemberInfo> members) {
            if (members != null) {
                for (GroupMemberInfo x : members) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'members' is null");
                }
            }
            this.members = members;
            return this;
        }

        @Override
        public Builder withGroupExternalId(String groupExternalId) {
            super.withGroupExternalId(groupExternalId);
            return this;
        }

        @Override
        public Builder withMemberCount(Long memberCount) {
            super.withMemberCount(memberCount);
            return this;
        }

        @Override
        public GroupFullInfo build() {
            return new GroupFullInfo(this.groupName, this.groupId, this.groupManagementType, this.created, this.groupExternalId, this.memberCount, this.members);
        }
    }
}

