/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.MemberAccessLevelResult;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SharedFolderMemberError {
    public static final SharedFolderMemberError INVALID_DROPBOX_ID = new SharedFolderMemberError().withTag(Tag.INVALID_DROPBOX_ID);
    public static final SharedFolderMemberError NOT_A_MEMBER = new SharedFolderMemberError().withTag(Tag.NOT_A_MEMBER);
    public static final SharedFolderMemberError OTHER = new SharedFolderMemberError().withTag(Tag.OTHER);
    private Tag _tag;
    private MemberAccessLevelResult noExplicitAccessValue;

    private SharedFolderMemberError() {
    }

    private SharedFolderMemberError withTag(Tag _tag) {
        SharedFolderMemberError result = new SharedFolderMemberError();
        result._tag = _tag;
        return result;
    }

    private SharedFolderMemberError withTagAndNoExplicitAccess(Tag _tag, MemberAccessLevelResult noExplicitAccessValue) {
        SharedFolderMemberError result = new SharedFolderMemberError();
        result._tag = _tag;
        result.noExplicitAccessValue = noExplicitAccessValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInvalidDropboxId() {
        return this._tag == Tag.INVALID_DROPBOX_ID;
    }

    public boolean isNotAMember() {
        return this._tag == Tag.NOT_A_MEMBER;
    }

    public boolean isNoExplicitAccess() {
        return this._tag == Tag.NO_EXPLICIT_ACCESS;
    }

    public static SharedFolderMemberError noExplicitAccess(MemberAccessLevelResult value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SharedFolderMemberError().withTagAndNoExplicitAccess(Tag.NO_EXPLICIT_ACCESS, value);
    }

    public MemberAccessLevelResult getNoExplicitAccessValue() {
        if (this._tag != Tag.NO_EXPLICIT_ACCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.NO_EXPLICIT_ACCESS, but was Tag." + this._tag.name());
        }
        return this.noExplicitAccessValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.noExplicitAccessValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SharedFolderMemberError) {
            SharedFolderMemberError other = (SharedFolderMemberError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case INVALID_DROPBOX_ID: {
                    return true;
                }
                case NOT_A_MEMBER: {
                    return true;
                }
                case NO_EXPLICIT_ACCESS: {
                    return this.noExplicitAccessValue == other.noExplicitAccessValue || this.noExplicitAccessValue.equals(other.noExplicitAccessValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SharedFolderMemberError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedFolderMemberError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case INVALID_DROPBOX_ID: {
                    g2.writeString("invalid_dropbox_id");
                    break;
                }
                case NOT_A_MEMBER: {
                    g2.writeString("not_a_member");
                    break;
                }
                case NO_EXPLICIT_ACCESS: {
                    g2.writeStartObject();
                    this.writeTag("no_explicit_access", g2);
                    MemberAccessLevelResult.Serializer.INSTANCE.serialize(value.noExplicitAccessValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public SharedFolderMemberError deserialize(JsonParser p) throws IOException, JsonParseException {
            SharedFolderMemberError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("invalid_dropbox_id".equals(tag)) {
                value = INVALID_DROPBOX_ID;
            } else if ("not_a_member".equals(tag)) {
                value = NOT_A_MEMBER;
            } else if ("no_explicit_access".equals(tag)) {
                MemberAccessLevelResult fieldValue = null;
                fieldValue = MemberAccessLevelResult.Serializer.INSTANCE.deserialize(p, true);
                value = SharedFolderMemberError.noExplicitAccess(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        INVALID_DROPBOX_ID,
        NOT_A_MEMBER,
        NO_EXPLICIT_ACCESS,
        OTHER;

    }
}

