/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class DeleteArg {
    protected final String path;
    protected final String parentRev;

    public DeleteArg(String path, String parentRev) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (parentRev != null) {
            if (parentRev.length() < 9) {
                throw new IllegalArgumentException("String 'parentRev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", parentRev)) {
                throw new IllegalArgumentException("String 'parentRev' does not match pattern");
            }
        }
        this.parentRev = parentRev;
    }

    public DeleteArg(String path) {
        this(path, null);
    }

    public String getPath() {
        return this.path;
    }

    public String getParentRev() {
        return this.parentRev;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.parentRev});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            DeleteArg other = (DeleteArg)obj;
            return (this.path == other.path || this.path.equals(other.path)) && (this.parentRev == other.parentRev || this.parentRev != null && this.parentRev.equals(other.parentRev));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<DeleteArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeleteArg value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g2);
            if (value.parentRev != null) {
                g2.writeFieldName("parent_rev");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentRev, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public DeleteArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_parentRev;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_parentRev = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("parent_rev".equals(field)) {
                        f_parentRev = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            DeleteArg value = new DeleteArg(f_path, f_parentRev);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

