/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands;

import com.almightyalpaca.discord.jdabutler.commands.Command;
import com.almightyalpaca.discord.jdabutler.util.gradle.GradleUtil;
import com.kantenkugel.discordbot.versioncheck.VersionCheckerRegistry;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.MessageBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class BuildGradleCommand
extends Command {
    private static final String[] ALIASES = new String[]{"build.gradle.kts"};

    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        MessageBuilder mb = new MessageBuilder();
        List<VersionedItem> items = VersionCheckerRegistry.getItemsFromString(content, true).stream().filter(item -> item.getGroupId() != null && item.getArtifactId() != null && item.getRepoType() != null).collect(Collectors.toList());
        boolean pretty = content.contains("pretty");
        boolean kotlin = message.getContentRaw().contains("build.gradle.kts");
        mb.appendCodeBlock(GradleUtil.getBuildFile(kotlin, GradleUtil.DEFAULT_PLUGINS, "com.example.jda.Bot", "1.0", "1.8", items, pretty), kotlin ? "kotlin" : "gradle");
        this.reply(event, mb.build());
    }

    @Override
    public String getHelp() {
        return "Shows an example build.gradle file";
    }

    @Override
    public String getName() {
        return "build.gradle";
    }

    @Override
    public String[] getAliases() {
        return ALIASES;
    }
}

