/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.commands.Command;
import com.almightyalpaca.discord.jdabutler.util.MavenUtil;
import com.almightyalpaca.discord.jdabutler.util.MiscUtils;
import com.kantenkugel.discordbot.versioncheck.VersionCheckerRegistry;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class MavenProjectCommand
extends Command {
    private static String POM;

    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        List<VersionedItem> items = VersionCheckerRegistry.getItemsFromString(content, true).stream().filter(item -> item.getGroupId() != null && item.getArtifactId() != null && item.getRepoType() != null).collect(Collectors.toList());
        String dependencyString = MavenUtil.getDependencyBlock(items, "    ");
        String repoString = MavenUtil.getRepositoryBlock(items, "    ");
        String pom = String.format(POM, repoString, dependencyString);
        this.reply(event, "Here: " + MiscUtils.hastebin(pom) + ".xml");
    }

    @Override
    public String getHelp() {
        return "Example maven project";
    }

    @Override
    public String getName() {
        return "pom.xml";
    }

    static {
        try {
            POM = new BufferedReader(new InputStreamReader(MavenProjectCommand.class.getResourceAsStream("/maven.pom"))).lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            Bot.LOG.error("Error getting template pom", e);
            POM = "Load failed.";
        }
    }
}

