/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum ThumbnailSize {
    W32H32,
    W64H64,
    W128H128,
    W256H256,
    W480H320,
    W640H480,
    W960H640,
    W1024H768,
    W2048H1536;


    static class Serializer
    extends UnionSerializer<ThumbnailSize> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ThumbnailSize value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case W32H32: {
                    g2.writeString("w32h32");
                    break;
                }
                case W64H64: {
                    g2.writeString("w64h64");
                    break;
                }
                case W128H128: {
                    g2.writeString("w128h128");
                    break;
                }
                case W256H256: {
                    g2.writeString("w256h256");
                    break;
                }
                case W480H320: {
                    g2.writeString("w480h320");
                    break;
                }
                case W640H480: {
                    g2.writeString("w640h480");
                    break;
                }
                case W960H640: {
                    g2.writeString("w960h640");
                    break;
                }
                case W1024H768: {
                    g2.writeString("w1024h768");
                    break;
                }
                case W2048H1536: {
                    g2.writeString("w2048h1536");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value));
                }
            }
        }

        @Override
        public ThumbnailSize deserialize(JsonParser p) throws IOException, JsonParseException {
            ThumbnailSize value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("w32h32".equals(tag)) {
                value = W32H32;
            } else if ("w64h64".equals(tag)) {
                value = W64H64;
            } else if ("w128h128".equals(tag)) {
                value = W128H128;
            } else if ("w256h256".equals(tag)) {
                value = W256H256;
            } else if ("w480h320".equals(tag)) {
                value = W480H320;
            } else if ("w640h480".equals(tag)) {
                value = W640H480;
            } else if ("w960h640".equals(tag)) {
                value = W960H640;
            } else if ("w1024h768".equals(tag)) {
                value = W1024H768;
            } else if ("w2048h1536".equals(tag)) {
                value = W2048H1536;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

