/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.filerequests;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class DeleteFileRequestArgs {
    protected final List<String> ids;

    public DeleteFileRequestArgs(List<String> ids) {
        if (ids == null) {
            throw new IllegalArgumentException("Required value for 'ids' is null");
        }
        for (String x : ids) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'ids' is null");
            }
            if (x.length() < 1) {
                throw new IllegalArgumentException("Stringan item in list 'ids' is shorter than 1");
            }
            if (Pattern.matches("[-_0-9a-zA-Z]+", x)) continue;
            throw new IllegalArgumentException("Stringan item in list 'ids' does not match pattern");
        }
        this.ids = ids;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.ids});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            DeleteFileRequestArgs other = (DeleteFileRequestArgs)obj;
            return this.ids == other.ids || this.ids.equals(other.ids);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<DeleteFileRequestArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeleteFileRequestArgs value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("ids");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.ids, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public DeleteFileRequestArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_ids;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_ids = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("ids".equals(field)) {
                        f_ids = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_ids == null) {
                    throw new JsonParseException(p, "Required field \"ids\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            DeleteFileRequestArgs value = new DeleteFileRequestArgs(f_ids);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

