/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.AddFolderMemberError;
import com.dropbox.core.v2.sharing.SharedFolderAccessError;
import com.dropbox.core.v2.sharing.SharedFolderMemberError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UpdateFolderMemberError {
    public static final UpdateFolderMemberError INSUFFICIENT_PLAN = new UpdateFolderMemberError().withTag(Tag.INSUFFICIENT_PLAN);
    public static final UpdateFolderMemberError NO_PERMISSION = new UpdateFolderMemberError().withTag(Tag.NO_PERMISSION);
    public static final UpdateFolderMemberError OTHER = new UpdateFolderMemberError().withTag(Tag.OTHER);
    private Tag _tag;
    private SharedFolderAccessError accessErrorValue;
    private SharedFolderMemberError memberErrorValue;
    private AddFolderMemberError noExplicitAccessValue;

    private UpdateFolderMemberError() {
    }

    private UpdateFolderMemberError withTag(Tag _tag) {
        UpdateFolderMemberError result = new UpdateFolderMemberError();
        result._tag = _tag;
        return result;
    }

    private UpdateFolderMemberError withTagAndAccessError(Tag _tag, SharedFolderAccessError accessErrorValue) {
        UpdateFolderMemberError result = new UpdateFolderMemberError();
        result._tag = _tag;
        result.accessErrorValue = accessErrorValue;
        return result;
    }

    private UpdateFolderMemberError withTagAndMemberError(Tag _tag, SharedFolderMemberError memberErrorValue) {
        UpdateFolderMemberError result = new UpdateFolderMemberError();
        result._tag = _tag;
        result.memberErrorValue = memberErrorValue;
        return result;
    }

    private UpdateFolderMemberError withTagAndNoExplicitAccess(Tag _tag, AddFolderMemberError noExplicitAccessValue) {
        UpdateFolderMemberError result = new UpdateFolderMemberError();
        result._tag = _tag;
        result.noExplicitAccessValue = noExplicitAccessValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static UpdateFolderMemberError accessError(SharedFolderAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UpdateFolderMemberError().withTagAndAccessError(Tag.ACCESS_ERROR, value);
    }

    public SharedFolderAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isMemberError() {
        return this._tag == Tag.MEMBER_ERROR;
    }

    public static UpdateFolderMemberError memberError(SharedFolderMemberError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UpdateFolderMemberError().withTagAndMemberError(Tag.MEMBER_ERROR, value);
    }

    public SharedFolderMemberError getMemberErrorValue() {
        if (this._tag != Tag.MEMBER_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.MEMBER_ERROR, but was Tag." + this._tag.name());
        }
        return this.memberErrorValue;
    }

    public boolean isNoExplicitAccess() {
        return this._tag == Tag.NO_EXPLICIT_ACCESS;
    }

    public static UpdateFolderMemberError noExplicitAccess(AddFolderMemberError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UpdateFolderMemberError().withTagAndNoExplicitAccess(Tag.NO_EXPLICIT_ACCESS, value);
    }

    public AddFolderMemberError getNoExplicitAccessValue() {
        if (this._tag != Tag.NO_EXPLICIT_ACCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.NO_EXPLICIT_ACCESS, but was Tag." + this._tag.name());
        }
        return this.noExplicitAccessValue;
    }

    public boolean isInsufficientPlan() {
        return this._tag == Tag.INSUFFICIENT_PLAN;
    }

    public boolean isNoPermission() {
        return this._tag == Tag.NO_PERMISSION;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.accessErrorValue, this.memberErrorValue, this.noExplicitAccessValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UpdateFolderMemberError) {
            UpdateFolderMemberError other = (UpdateFolderMemberError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case MEMBER_ERROR: {
                    return this.memberErrorValue == other.memberErrorValue || this.memberErrorValue.equals(other.memberErrorValue);
                }
                case NO_EXPLICIT_ACCESS: {
                    return this.noExplicitAccessValue == other.noExplicitAccessValue || this.noExplicitAccessValue.equals(other.noExplicitAccessValue);
                }
                case INSUFFICIENT_PLAN: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UpdateFolderMemberError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UpdateFolderMemberError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ACCESS_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("access_error", g2);
                    g2.writeFieldName("access_error");
                    SharedFolderAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case MEMBER_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("member_error", g2);
                    g2.writeFieldName("member_error");
                    SharedFolderMemberError.Serializer.INSTANCE.serialize(value.memberErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case NO_EXPLICIT_ACCESS: {
                    g2.writeStartObject();
                    this.writeTag("no_explicit_access", g2);
                    g2.writeFieldName("no_explicit_access");
                    AddFolderMemberError.Serializer.INSTANCE.serialize(value.noExplicitAccessValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case INSUFFICIENT_PLAN: {
                    g2.writeString("insufficient_plan");
                    break;
                }
                case NO_PERMISSION: {
                    g2.writeString("no_permission");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public UpdateFolderMemberError deserialize(JsonParser p) throws IOException, JsonParseException {
            UpdateFolderMemberError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("access_error".equals(tag)) {
                SharedFolderAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = SharedFolderAccessError.Serializer.INSTANCE.deserialize(p);
                value = UpdateFolderMemberError.accessError(fieldValue);
            } else if ("member_error".equals(tag)) {
                SharedFolderMemberError fieldValue = null;
                Serializer.expectField("member_error", p);
                fieldValue = SharedFolderMemberError.Serializer.INSTANCE.deserialize(p);
                value = UpdateFolderMemberError.memberError(fieldValue);
            } else if ("no_explicit_access".equals(tag)) {
                AddFolderMemberError fieldValue = null;
                Serializer.expectField("no_explicit_access", p);
                fieldValue = AddFolderMemberError.Serializer.INSTANCE.deserialize(p);
                value = UpdateFolderMemberError.noExplicitAccess(fieldValue);
            } else {
                value = "insufficient_plan".equals(tag) ? INSUFFICIENT_PLAN : ("no_permission".equals(tag) ? NO_PERMISSION : OTHER);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ACCESS_ERROR,
        MEMBER_ERROR,
        NO_EXPLICIT_ACCESS,
        INSUFFICIENT_PLAN,
        NO_PERMISSION,
        OTHER;

    }
}

