/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.json.JsonWriter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class DbxHost {
    public static final DbxHost DEFAULT = new DbxHost("api.dropboxapi.com", "content.dropboxapi.com", "www.dropbox.com", "notify.dropboxapi.com");
    private final String api;
    private final String content;
    private final String web;
    private final String notify;
    public static final JsonReader<DbxHost> Reader = new JsonReader<DbxHost>(){

        @Override
        public DbxHost read(JsonParser parser) throws IOException, JsonReadException {
            JsonToken t = parser.getCurrentToken();
            if (t == JsonToken.VALUE_STRING) {
                String s2 = parser.getText();
                JsonReader.nextToken(parser);
                return DbxHost.fromBaseHost(s2);
            }
            if (t == JsonToken.START_OBJECT) {
                JsonLocation top = parser.getTokenLocation();
                1.nextToken(parser);
                String api = null;
                String content = null;
                String web = null;
                String notify = null;
                while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    parser.nextToken();
                    try {
                        if (fieldName.equals("api")) {
                            api = JsonReader.StringReader.readField(parser, fieldName, api);
                            continue;
                        }
                        if (fieldName.equals("content")) {
                            content = JsonReader.StringReader.readField(parser, fieldName, content);
                            continue;
                        }
                        if (fieldName.equals("web")) {
                            web = JsonReader.StringReader.readField(parser, fieldName, web);
                            continue;
                        }
                        if (fieldName.equals("notify")) {
                            notify = JsonReader.StringReader.readField(parser, fieldName, notify);
                            continue;
                        }
                        throw new JsonReadException("unknown field", parser.getCurrentLocation());
                    }
                    catch (JsonReadException ex) {
                        throw ex.addFieldContext(fieldName);
                    }
                }
                JsonReader.expectObjectEnd(parser);
                if (api == null) {
                    throw new JsonReadException("missing field \"api\"", top);
                }
                if (content == null) {
                    throw new JsonReadException("missing field \"content\"", top);
                }
                if (web == null) {
                    throw new JsonReadException("missing field \"web\"", top);
                }
                if (notify == null) {
                    throw new JsonReadException("missing field \"notify\"", top);
                }
                return new DbxHost(api, content, web, notify);
            }
            throw new JsonReadException("expecting a string or an object", parser.getTokenLocation());
        }
    };
    public static final JsonWriter<DbxHost> Writer = new JsonWriter<DbxHost>(){

        @Override
        public void write(DbxHost host, JsonGenerator g2) throws IOException {
            String base = host.inferBaseHost();
            if (base != null) {
                g2.writeString(base);
            } else {
                g2.writeStartObject();
                g2.writeStringField("api", host.api);
                g2.writeStringField("content", host.content);
                g2.writeStringField("web", host.web);
                g2.writeStringField("notify", host.notify);
                g2.writeEndObject();
            }
        }
    };

    public DbxHost(String api, String content, String web, String notify) {
        this.api = api;
        this.content = content;
        this.web = web;
        this.notify = notify;
    }

    public String getApi() {
        return this.api;
    }

    public String getContent() {
        return this.content;
    }

    public String getWeb() {
        return this.web;
    }

    public String getNotify() {
        return this.notify;
    }

    public int hashCode() {
        return Arrays.hashCode(new String[]{this.api, this.content, this.web, this.notify});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DbxHost) {
            DbxHost other = (DbxHost)obj;
            return other.api.equals(this.api) && other.content.equals(this.content) && other.web.equals(this.web) && other.notify.equals(this.notify);
        }
        return false;
    }

    private static DbxHost fromBaseHost(String s2) {
        return new DbxHost("api-" + s2, "api-content-" + s2, "meta-" + s2, "api-notify-" + s2);
    }

    private String inferBaseHost() {
        if (this.web.startsWith("meta-") && this.api.startsWith("api-") && this.content.startsWith("api-content-") && this.notify.startsWith("api-notify-")) {
            String webBase = this.web.substring("meta-".length());
            String apiBase = this.api.substring("api-".length());
            String contentBase = this.content.substring("api-content-".length());
            String notifyBase = this.notify.substring("api-notify-".length());
            if (webBase.equals(apiBase) && webBase.equals(contentBase) && webBase.equals(notifyBase)) {
                return webBase;
            }
        }
        return null;
    }
}

