/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.AudienceRestrictingSharedFolder;
import com.dropbox.core.v2.sharing.LinkAudience;
import com.dropbox.core.v2.sharing.LinkPermission;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class SharedContentLinkMetadataBase {
    protected final AccessLevel accessLevel;
    protected final List<LinkAudience> audienceOptions;
    protected final AudienceRestrictingSharedFolder audienceRestrictingSharedFolder;
    protected final LinkAudience currentAudience;
    protected final Date expiry;
    protected final List<LinkPermission> linkPermissions;
    protected final boolean passwordProtected;

    public SharedContentLinkMetadataBase(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected, AccessLevel accessLevel, AudienceRestrictingSharedFolder audienceRestrictingSharedFolder, Date expiry) {
        this.accessLevel = accessLevel;
        if (audienceOptions == null) {
            throw new IllegalArgumentException("Required value for 'audienceOptions' is null");
        }
        for (LinkAudience linkAudience : audienceOptions) {
            if (linkAudience != null) continue;
            throw new IllegalArgumentException("An item in list 'audienceOptions' is null");
        }
        this.audienceOptions = audienceOptions;
        this.audienceRestrictingSharedFolder = audienceRestrictingSharedFolder;
        if (currentAudience == null) {
            throw new IllegalArgumentException("Required value for 'currentAudience' is null");
        }
        this.currentAudience = currentAudience;
        this.expiry = LangUtil.truncateMillis(expiry);
        if (linkPermissions == null) {
            throw new IllegalArgumentException("Required value for 'linkPermissions' is null");
        }
        for (LinkPermission linkPermission : linkPermissions) {
            if (linkPermission != null) continue;
            throw new IllegalArgumentException("An item in list 'linkPermissions' is null");
        }
        this.linkPermissions = linkPermissions;
        this.passwordProtected = passwordProtected;
    }

    public SharedContentLinkMetadataBase(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected) {
        this(audienceOptions, currentAudience, linkPermissions, passwordProtected, null, null, null);
    }

    public List<LinkAudience> getAudienceOptions() {
        return this.audienceOptions;
    }

    public LinkAudience getCurrentAudience() {
        return this.currentAudience;
    }

    public List<LinkPermission> getLinkPermissions() {
        return this.linkPermissions;
    }

    public boolean getPasswordProtected() {
        return this.passwordProtected;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public AudienceRestrictingSharedFolder getAudienceRestrictingSharedFolder() {
        return this.audienceRestrictingSharedFolder;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public static Builder newBuilder(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected) {
        return new Builder(audienceOptions, currentAudience, linkPermissions, passwordProtected);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accessLevel, this.audienceOptions, this.audienceRestrictingSharedFolder, this.currentAudience, this.expiry, this.linkPermissions, this.passwordProtected});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedContentLinkMetadataBase other = (SharedContentLinkMetadataBase)obj;
            return !(this.audienceOptions != other.audienceOptions && !this.audienceOptions.equals(other.audienceOptions) || this.currentAudience != other.currentAudience && !this.currentAudience.equals((Object)other.currentAudience) || this.linkPermissions != other.linkPermissions && !this.linkPermissions.equals(other.linkPermissions) || this.passwordProtected != other.passwordProtected || this.accessLevel != other.accessLevel && (this.accessLevel == null || !this.accessLevel.equals((Object)other.accessLevel)) || this.audienceRestrictingSharedFolder != other.audienceRestrictingSharedFolder && (this.audienceRestrictingSharedFolder == null || !this.audienceRestrictingSharedFolder.equals(other.audienceRestrictingSharedFolder)) || this.expiry != other.expiry && (this.expiry == null || !this.expiry.equals(other.expiry)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    private static class Serializer
    extends StructSerializer<SharedContentLinkMetadataBase> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void serialize(SharedContentLinkMetadataBase value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("audience_options");
            StoneSerializers.list(LinkAudience.Serializer.INSTANCE).serialize(value.audienceOptions, g2);
            g2.writeFieldName("current_audience");
            LinkAudience.Serializer.INSTANCE.serialize(value.currentAudience, g2);
            g2.writeFieldName("link_permissions");
            StoneSerializers.list(LinkPermission.Serializer.INSTANCE).serialize(value.linkPermissions, g2);
            g2.writeFieldName("password_protected");
            StoneSerializers.boolean_().serialize((Boolean)value.passwordProtected, g2);
            if (value.accessLevel != null) {
                g2.writeFieldName("access_level");
                StoneSerializers.nullable(AccessLevel.Serializer.INSTANCE).serialize(value.accessLevel, g2);
            }
            if (value.audienceRestrictingSharedFolder != null) {
                g2.writeFieldName("audience_restricting_shared_folder");
                StoneSerializers.nullableStruct(AudienceRestrictingSharedFolder.Serializer.INSTANCE).serialize(value.audienceRestrictingSharedFolder, g2);
            }
            if (value.expiry != null) {
                g2.writeFieldName("expiry");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.expiry, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public SharedContentLinkMetadataBase deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_expiry;
            AudienceRestrictingSharedFolder f_audienceRestrictingSharedFolder;
            AccessLevel f_accessLevel;
            Boolean f_passwordProtected;
            List<LinkPermission> f_linkPermissions;
            LinkAudience f_currentAudience;
            List<LinkAudience> f_audienceOptions;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_audienceOptions = null;
                f_currentAudience = null;
                f_linkPermissions = null;
                f_passwordProtected = null;
                f_accessLevel = null;
                f_audienceRestrictingSharedFolder = null;
                f_expiry = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("audience_options".equals(field)) {
                        f_audienceOptions = StoneSerializers.list(LinkAudience.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("current_audience".equals(field)) {
                        f_currentAudience = LinkAudience.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("link_permissions".equals(field)) {
                        f_linkPermissions = StoneSerializers.list(LinkPermission.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("password_protected".equals(field)) {
                        f_passwordProtected = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("access_level".equals(field)) {
                        f_accessLevel = StoneSerializers.nullable(AccessLevel.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("audience_restricting_shared_folder".equals(field)) {
                        f_audienceRestrictingSharedFolder = StoneSerializers.nullableStruct(AudienceRestrictingSharedFolder.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("expiry".equals(field)) {
                        f_expiry = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_audienceOptions == null) {
                    throw new JsonParseException(p, "Required field \"audience_options\" missing.");
                }
                if (f_currentAudience == null) {
                    throw new JsonParseException(p, "Required field \"current_audience\" missing.");
                }
                if (f_linkPermissions == null) {
                    throw new JsonParseException(p, "Required field \"link_permissions\" missing.");
                }
                if (f_passwordProtected == null) {
                    throw new JsonParseException(p, "Required field \"password_protected\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedContentLinkMetadataBase value = new SharedContentLinkMetadataBase(f_audienceOptions, f_currentAudience, f_linkPermissions, f_passwordProtected, f_accessLevel, f_audienceRestrictingSharedFolder, f_expiry);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final List<LinkAudience> audienceOptions;
        protected final LinkAudience currentAudience;
        protected final List<LinkPermission> linkPermissions;
        protected final boolean passwordProtected;
        protected AccessLevel accessLevel;
        protected AudienceRestrictingSharedFolder audienceRestrictingSharedFolder;
        protected Date expiry;

        protected Builder(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected) {
            if (audienceOptions == null) {
                throw new IllegalArgumentException("Required value for 'audienceOptions' is null");
            }
            for (LinkAudience linkAudience : audienceOptions) {
                if (linkAudience != null) continue;
                throw new IllegalArgumentException("An item in list 'audienceOptions' is null");
            }
            this.audienceOptions = audienceOptions;
            if (currentAudience == null) {
                throw new IllegalArgumentException("Required value for 'currentAudience' is null");
            }
            this.currentAudience = currentAudience;
            if (linkPermissions == null) {
                throw new IllegalArgumentException("Required value for 'linkPermissions' is null");
            }
            for (LinkPermission linkPermission : linkPermissions) {
                if (linkPermission != null) continue;
                throw new IllegalArgumentException("An item in list 'linkPermissions' is null");
            }
            this.linkPermissions = linkPermissions;
            this.passwordProtected = passwordProtected;
            this.accessLevel = null;
            this.audienceRestrictingSharedFolder = null;
            this.expiry = null;
        }

        public Builder withAccessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder withAudienceRestrictingSharedFolder(AudienceRestrictingSharedFolder audienceRestrictingSharedFolder) {
            this.audienceRestrictingSharedFolder = audienceRestrictingSharedFolder;
            return this;
        }

        public Builder withExpiry(Date expiry) {
            this.expiry = LangUtil.truncateMillis(expiry);
            return this;
        }

        public SharedContentLinkMetadataBase build() {
            return new SharedContentLinkMetadataBase(this.audienceOptions, this.currentAudience, this.linkPermissions, this.passwordProtected, this.accessLevel, this.audienceRestrictingSharedFolder, this.expiry);
        }
    }
}

