/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.AddMemberSelectorError;
import com.dropbox.core.v2.sharing.SharedFolderAccessError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class AddFolderMemberError {
    public static final AddFolderMemberError EMAIL_UNVERIFIED = new AddFolderMemberError().withTag(Tag.EMAIL_UNVERIFIED);
    public static final AddFolderMemberError BANNED_MEMBER = new AddFolderMemberError().withTag(Tag.BANNED_MEMBER);
    public static final AddFolderMemberError CANT_SHARE_OUTSIDE_TEAM = new AddFolderMemberError().withTag(Tag.CANT_SHARE_OUTSIDE_TEAM);
    public static final AddFolderMemberError RATE_LIMIT = new AddFolderMemberError().withTag(Tag.RATE_LIMIT);
    public static final AddFolderMemberError TOO_MANY_INVITEES = new AddFolderMemberError().withTag(Tag.TOO_MANY_INVITEES);
    public static final AddFolderMemberError INSUFFICIENT_PLAN = new AddFolderMemberError().withTag(Tag.INSUFFICIENT_PLAN);
    public static final AddFolderMemberError TEAM_FOLDER = new AddFolderMemberError().withTag(Tag.TEAM_FOLDER);
    public static final AddFolderMemberError NO_PERMISSION = new AddFolderMemberError().withTag(Tag.NO_PERMISSION);
    public static final AddFolderMemberError INVALID_SHARED_FOLDER = new AddFolderMemberError().withTag(Tag.INVALID_SHARED_FOLDER);
    public static final AddFolderMemberError OTHER = new AddFolderMemberError().withTag(Tag.OTHER);
    private Tag _tag;
    private SharedFolderAccessError accessErrorValue;
    private AddMemberSelectorError badMemberValue;
    private Long tooManyMembersValue;
    private Long tooManyPendingInvitesValue;

    private AddFolderMemberError() {
    }

    private AddFolderMemberError withTag(Tag _tag) {
        AddFolderMemberError result = new AddFolderMemberError();
        result._tag = _tag;
        return result;
    }

    private AddFolderMemberError withTagAndAccessError(Tag _tag, SharedFolderAccessError accessErrorValue) {
        AddFolderMemberError result = new AddFolderMemberError();
        result._tag = _tag;
        result.accessErrorValue = accessErrorValue;
        return result;
    }

    private AddFolderMemberError withTagAndBadMember(Tag _tag, AddMemberSelectorError badMemberValue) {
        AddFolderMemberError result = new AddFolderMemberError();
        result._tag = _tag;
        result.badMemberValue = badMemberValue;
        return result;
    }

    private AddFolderMemberError withTagAndTooManyMembers(Tag _tag, Long tooManyMembersValue) {
        AddFolderMemberError result = new AddFolderMemberError();
        result._tag = _tag;
        result.tooManyMembersValue = tooManyMembersValue;
        return result;
    }

    private AddFolderMemberError withTagAndTooManyPendingInvites(Tag _tag, Long tooManyPendingInvitesValue) {
        AddFolderMemberError result = new AddFolderMemberError();
        result._tag = _tag;
        result.tooManyPendingInvitesValue = tooManyPendingInvitesValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static AddFolderMemberError accessError(SharedFolderAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AddFolderMemberError().withTagAndAccessError(Tag.ACCESS_ERROR, value);
    }

    public SharedFolderAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isEmailUnverified() {
        return this._tag == Tag.EMAIL_UNVERIFIED;
    }

    public boolean isBannedMember() {
        return this._tag == Tag.BANNED_MEMBER;
    }

    public boolean isBadMember() {
        return this._tag == Tag.BAD_MEMBER;
    }

    public static AddFolderMemberError badMember(AddMemberSelectorError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AddFolderMemberError().withTagAndBadMember(Tag.BAD_MEMBER, value);
    }

    public AddMemberSelectorError getBadMemberValue() {
        if (this._tag != Tag.BAD_MEMBER) {
            throw new IllegalStateException("Invalid tag: required Tag.BAD_MEMBER, but was Tag." + this._tag.name());
        }
        return this.badMemberValue;
    }

    public boolean isCantShareOutsideTeam() {
        return this._tag == Tag.CANT_SHARE_OUTSIDE_TEAM;
    }

    public boolean isTooManyMembers() {
        return this._tag == Tag.TOO_MANY_MEMBERS;
    }

    public static AddFolderMemberError tooManyMembers(long value) {
        return new AddFolderMemberError().withTagAndTooManyMembers(Tag.TOO_MANY_MEMBERS, value);
    }

    public long getTooManyMembersValue() {
        if (this._tag != Tag.TOO_MANY_MEMBERS) {
            throw new IllegalStateException("Invalid tag: required Tag.TOO_MANY_MEMBERS, but was Tag." + this._tag.name());
        }
        return this.tooManyMembersValue;
    }

    public boolean isTooManyPendingInvites() {
        return this._tag == Tag.TOO_MANY_PENDING_INVITES;
    }

    public static AddFolderMemberError tooManyPendingInvites(long value) {
        return new AddFolderMemberError().withTagAndTooManyPendingInvites(Tag.TOO_MANY_PENDING_INVITES, value);
    }

    public long getTooManyPendingInvitesValue() {
        if (this._tag != Tag.TOO_MANY_PENDING_INVITES) {
            throw new IllegalStateException("Invalid tag: required Tag.TOO_MANY_PENDING_INVITES, but was Tag." + this._tag.name());
        }
        return this.tooManyPendingInvitesValue;
    }

    public boolean isRateLimit() {
        return this._tag == Tag.RATE_LIMIT;
    }

    public boolean isTooManyInvitees() {
        return this._tag == Tag.TOO_MANY_INVITEES;
    }

    public boolean isInsufficientPlan() {
        return this._tag == Tag.INSUFFICIENT_PLAN;
    }

    public boolean isTeamFolder() {
        return this._tag == Tag.TEAM_FOLDER;
    }

    public boolean isNoPermission() {
        return this._tag == Tag.NO_PERMISSION;
    }

    public boolean isInvalidSharedFolder() {
        return this._tag == Tag.INVALID_SHARED_FOLDER;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.accessErrorValue, this.badMemberValue, this.tooManyMembersValue, this.tooManyPendingInvitesValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AddFolderMemberError) {
            AddFolderMemberError other = (AddFolderMemberError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case EMAIL_UNVERIFIED: {
                    return true;
                }
                case BANNED_MEMBER: {
                    return true;
                }
                case BAD_MEMBER: {
                    return this.badMemberValue == other.badMemberValue || this.badMemberValue.equals(other.badMemberValue);
                }
                case CANT_SHARE_OUTSIDE_TEAM: {
                    return true;
                }
                case TOO_MANY_MEMBERS: {
                    return this.tooManyMembersValue == other.tooManyMembersValue;
                }
                case TOO_MANY_PENDING_INVITES: {
                    return this.tooManyPendingInvitesValue == other.tooManyPendingInvitesValue;
                }
                case RATE_LIMIT: {
                    return true;
                }
                case TOO_MANY_INVITEES: {
                    return true;
                }
                case INSUFFICIENT_PLAN: {
                    return true;
                }
                case TEAM_FOLDER: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case INVALID_SHARED_FOLDER: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<AddFolderMemberError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AddFolderMemberError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ACCESS_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("access_error", g2);
                    g2.writeFieldName("access_error");
                    SharedFolderAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case EMAIL_UNVERIFIED: {
                    g2.writeString("email_unverified");
                    break;
                }
                case BANNED_MEMBER: {
                    g2.writeString("banned_member");
                    break;
                }
                case BAD_MEMBER: {
                    g2.writeStartObject();
                    this.writeTag("bad_member", g2);
                    g2.writeFieldName("bad_member");
                    AddMemberSelectorError.Serializer.INSTANCE.serialize(value.badMemberValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case CANT_SHARE_OUTSIDE_TEAM: {
                    g2.writeString("cant_share_outside_team");
                    break;
                }
                case TOO_MANY_MEMBERS: {
                    g2.writeStartObject();
                    this.writeTag("too_many_members", g2);
                    g2.writeFieldName("too_many_members");
                    StoneSerializers.uInt64().serialize(value.tooManyMembersValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case TOO_MANY_PENDING_INVITES: {
                    g2.writeStartObject();
                    this.writeTag("too_many_pending_invites", g2);
                    g2.writeFieldName("too_many_pending_invites");
                    StoneSerializers.uInt64().serialize(value.tooManyPendingInvitesValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case RATE_LIMIT: {
                    g2.writeString("rate_limit");
                    break;
                }
                case TOO_MANY_INVITEES: {
                    g2.writeString("too_many_invitees");
                    break;
                }
                case INSUFFICIENT_PLAN: {
                    g2.writeString("insufficient_plan");
                    break;
                }
                case TEAM_FOLDER: {
                    g2.writeString("team_folder");
                    break;
                }
                case NO_PERMISSION: {
                    g2.writeString("no_permission");
                    break;
                }
                case INVALID_SHARED_FOLDER: {
                    g2.writeString("invalid_shared_folder");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public AddFolderMemberError deserialize(JsonParser p) throws IOException, JsonParseException {
            AddFolderMemberError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("access_error".equals(tag)) {
                SharedFolderAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = SharedFolderAccessError.Serializer.INSTANCE.deserialize(p);
                value = AddFolderMemberError.accessError(fieldValue);
            } else if ("email_unverified".equals(tag)) {
                value = EMAIL_UNVERIFIED;
            } else if ("banned_member".equals(tag)) {
                value = BANNED_MEMBER;
            } else if ("bad_member".equals(tag)) {
                AddMemberSelectorError fieldValue = null;
                Serializer.expectField("bad_member", p);
                fieldValue = AddMemberSelectorError.Serializer.INSTANCE.deserialize(p);
                value = AddFolderMemberError.badMember(fieldValue);
            } else if ("cant_share_outside_team".equals(tag)) {
                value = CANT_SHARE_OUTSIDE_TEAM;
            } else if ("too_many_members".equals(tag)) {
                Long fieldValue = null;
                Serializer.expectField("too_many_members", p);
                fieldValue = StoneSerializers.uInt64().deserialize(p);
                value = AddFolderMemberError.tooManyMembers(fieldValue);
            } else if ("too_many_pending_invites".equals(tag)) {
                Long fieldValue = null;
                Serializer.expectField("too_many_pending_invites", p);
                fieldValue = StoneSerializers.uInt64().deserialize(p);
                value = AddFolderMemberError.tooManyPendingInvites(fieldValue);
            } else {
                value = "rate_limit".equals(tag) ? RATE_LIMIT : ("too_many_invitees".equals(tag) ? TOO_MANY_INVITEES : ("insufficient_plan".equals(tag) ? INSUFFICIENT_PLAN : ("team_folder".equals(tag) ? TEAM_FOLDER : ("no_permission".equals(tag) ? NO_PERMISSION : ("invalid_shared_folder".equals(tag) ? INVALID_SHARED_FOLDER : OTHER)))));
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ACCESS_ERROR,
        EMAIL_UNVERIFIED,
        BANNED_MEMBER,
        BAD_MEMBER,
        CANT_SHARE_OUTSIDE_TEAM,
        TOO_MANY_MEMBERS,
        TOO_MANY_PENDING_INVITES,
        RATE_LIMIT,
        TOO_MANY_INVITEES,
        INSUFFICIENT_PLAN,
        TEAM_FOLDER,
        NO_PERMISSION,
        INVALID_SHARED_FOLDER,
        OTHER;

    }
}

