/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SaveCopyReferenceError {
    public static final SaveCopyReferenceError INVALID_COPY_REFERENCE = new SaveCopyReferenceError().withTag(Tag.INVALID_COPY_REFERENCE);
    public static final SaveCopyReferenceError NO_PERMISSION = new SaveCopyReferenceError().withTag(Tag.NO_PERMISSION);
    public static final SaveCopyReferenceError NOT_FOUND = new SaveCopyReferenceError().withTag(Tag.NOT_FOUND);
    public static final SaveCopyReferenceError TOO_MANY_FILES = new SaveCopyReferenceError().withTag(Tag.TOO_MANY_FILES);
    public static final SaveCopyReferenceError OTHER = new SaveCopyReferenceError().withTag(Tag.OTHER);
    private Tag _tag;
    private WriteError pathValue;

    private SaveCopyReferenceError() {
    }

    private SaveCopyReferenceError withTag(Tag _tag) {
        SaveCopyReferenceError result = new SaveCopyReferenceError();
        result._tag = _tag;
        return result;
    }

    private SaveCopyReferenceError withTagAndPath(Tag _tag, WriteError pathValue) {
        SaveCopyReferenceError result = new SaveCopyReferenceError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static SaveCopyReferenceError path(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SaveCopyReferenceError().withTagAndPath(Tag.PATH, value);
    }

    public WriteError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isInvalidCopyReference() {
        return this._tag == Tag.INVALID_COPY_REFERENCE;
    }

    public boolean isNoPermission() {
        return this._tag == Tag.NO_PERMISSION;
    }

    public boolean isNotFound() {
        return this._tag == Tag.NOT_FOUND;
    }

    public boolean isTooManyFiles() {
        return this._tag == Tag.TOO_MANY_FILES;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SaveCopyReferenceError) {
            SaveCopyReferenceError other = (SaveCopyReferenceError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case INVALID_COPY_REFERENCE: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case NOT_FOUND: {
                    return true;
                }
                case TOO_MANY_FILES: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SaveCopyReferenceError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SaveCopyReferenceError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g2.writeStartObject();
                    this.writeTag("path", g2);
                    g2.writeFieldName("path");
                    WriteError.Serializer.INSTANCE.serialize(value.pathValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case INVALID_COPY_REFERENCE: {
                    g2.writeString("invalid_copy_reference");
                    break;
                }
                case NO_PERMISSION: {
                    g2.writeString("no_permission");
                    break;
                }
                case NOT_FOUND: {
                    g2.writeString("not_found");
                    break;
                }
                case TOO_MANY_FILES: {
                    g2.writeString("too_many_files");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public SaveCopyReferenceError deserialize(JsonParser p) throws IOException, JsonParseException {
            SaveCopyReferenceError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                WriteError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = WriteError.Serializer.INSTANCE.deserialize(p);
                value = SaveCopyReferenceError.path(fieldValue);
            } else {
                value = "invalid_copy_reference".equals(tag) ? INVALID_COPY_REFERENCE : ("no_permission".equals(tag) ? NO_PERMISSION : ("not_found".equals(tag) ? NOT_FOUND : ("too_many_files".equals(tag) ? TOO_MANY_FILES : OTHER)));
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        INVALID_COPY_REFERENCE,
        NO_PERMISSION,
        NOT_FOUND,
        TOO_MANY_FILES,
        OTHER;

    }
}

