/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.util;

import com.almightyalpaca.discord.jdabutler.Bot;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;

public class MiscUtils {
    private static String HASTEBIN_SERVER = "https://hastebin.de/";

    public static ThreadFactory newThreadFactory(String threadName) {
        return MiscUtils.newThreadFactory(threadName, Bot.LOG);
    }

    public static ThreadFactory newThreadFactory(String threadName, boolean isDaemon) {
        return MiscUtils.newThreadFactory(threadName, Bot.LOG, isDaemon);
    }

    public static ThreadFactory newThreadFactory(String threadName, Logger logger) {
        return MiscUtils.newThreadFactory(threadName, logger, true);
    }

    public static ThreadFactory newThreadFactory(String threadName, Logger logger, boolean isdaemon) {
        return r -> {
            Thread t = new Thread(r, threadName);
            t.setDaemon(isdaemon);
            t.setUncaughtExceptionHandler((thread, throwable) -> logger.error("There was a uncaught exception in the {} threadpool", (Object)thread.getName(), (Object)throwable));
            return t;
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String hastebin(String text) {
        try (Response response = Bot.httpClient.newCall(new Request.Builder().post(RequestBody.create(MediaType.parse("text/plain"), text)).url(HASTEBIN_SERVER + "documents").header("User-Agent", "Mozilla/5.0 JDA-Butler").build()).execute();){
            if (!response.isSuccessful()) {
                String string2 = null;
                return string2;
            }
            JSONObject obj = new JSONObject(new JSONTokener(response.body().charStream()));
            String string = HASTEBIN_SERVER + obj.getString("key");
            return string;
        }
        catch (Exception e) {
            Bot.LOG.warn("Error posting text to hastebin", e);
            return null;
        }
    }

    public static void announce(TextChannel channel, Role role, Message message, boolean slowmode) {
        if (slowmode) {
            channel.getManager().setSlowmode(30).queue(v -> channel.getManager().setSlowmode(0).queueAfter(2L, TimeUnit.MINUTES));
        }
        role.getManager().setMentionable(true).queue(v -> channel.sendMessage(message).queue(v2 -> role.getManager().setMentionable(false).queue()));
    }
}

