/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands.moderation;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.commands.Command;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class SlowmodeCommand
extends Command {
    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        int seconds;
        if (!Bot.isHelper(sender)) {
            this.sendFailed(message);
            return;
        }
        String args = content.trim().toLowerCase();
        if (args.isEmpty()) {
            this.reply(event, "Missing argument: " + this.getHelp());
            return;
        }
        if (args.equals("off") || args.equals("false")) {
            seconds = 0;
        } else {
            try {
                seconds = Math.max(0, Math.min(Integer.parseInt(args), 120));
            }
            catch (NumberFormatException ignored) {
                this.reply(event, "Could not parse argument");
                return;
            }
        }
        channel.getManager().setSlowmode(seconds).submit().thenRun(() -> this.sendSuccess(event.getMessage()));
    }

    @Override
    public String getHelp() {
        return "`slowmode <seconds | off>`";
    }

    @Override
    public String getName() {
        return "slowmode";
    }
}

