/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands;

import com.almightyalpaca.discord.jdabutler.commands.ReactionListenerRegistry;
import com.almightyalpaca.discord.jdabutler.util.FixedSizeCache;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.function.Consumer;
import net.dv8tion.jda.api.MessageBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public abstract class Command {
    private static final FixedSizeCache<Long, TLongSet> MESSAGE_LINK_MAP = new FixedSizeCache(20);

    static void removeResponses(TextChannel channel, long messageId, ReactionListenerRegistry reactionRegistry) {
        TLongSet responses = MESSAGE_LINK_MAP.get(messageId);
        if (responses != null) {
            responses.forEach(msgId -> {
                reactionRegistry.cancel(msgId);
                return true;
            });
            channel.purgeMessagesById(responses.toArray());
        }
    }

    public static void linkMessage(long commandId, long responseId) {
        TLongSet set;
        if (!MESSAGE_LINK_MAP.contains(commandId)) {
            set = new TLongHashSet(2);
            MESSAGE_LINK_MAP.add(commandId, set);
        } else {
            set = MESSAGE_LINK_MAP.get(commandId);
        }
        set.add(responseId);
    }

    public abstract void dispatch(User var1, TextChannel var2, Message var3, String var4, GuildMessageReceivedEvent var5);

    public String[] getAliases() {
        return new String[0];
    }

    public abstract String getHelp();

    public abstract String getName();

    protected void sendFailed(Message message) {
        message.addReaction("\u274c").queue();
    }

    protected void sendSuccess(Message message) {
        message.addReaction("\u2705").queue();
    }

    protected void reply(GuildMessageReceivedEvent event, String message) {
        this.reply(event, message, null);
    }

    protected void reply(GuildMessageReceivedEvent event, String message, Consumer<Message> successConsumer) {
        this.reply(event, new MessageBuilder(message).build(), successConsumer);
    }

    protected void reply(GuildMessageReceivedEvent event, MessageEmbed embed) {
        this.reply(event, embed, null);
    }

    protected void reply(GuildMessageReceivedEvent event, MessageEmbed embed, Consumer<Message> successConsumer) {
        this.reply(event, new MessageBuilder(embed).build(), successConsumer);
    }

    protected void reply(GuildMessageReceivedEvent event, Message message) {
        this.reply(event, message, null);
    }

    protected void reply(GuildMessageReceivedEvent event, Message message, Consumer<Message> successConsumer) {
        event.getChannel().sendMessage(message).queue(msg -> {
            Command.linkMessage(event.getMessageIdLong(), msg.getIdLong());
            if (successConsumer != null) {
                successConsumer.accept((Message)msg);
            }
        });
    }
}

