/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck.items;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.kantenkugel.discordbot.versioncheck.DependencyType;
import com.kantenkugel.discordbot.versioncheck.RepoType;
import com.kantenkugel.discordbot.versioncheck.UpdateHandler;
import com.kantenkugel.discordbot.versioncheck.VersionUtils;
import com.kantenkugel.discordbot.versioncheck.changelog.ChangelogProvider;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;

public abstract class VersionedItem {
    private String version = null;

    public abstract String getName();

    public String getDescription() {
        throw new UnsupportedOperationException();
    }

    public List<String> getAliases() {
        return null;
    }

    public abstract RepoType getRepoType();

    public abstract String getGroupId();

    public abstract String getArtifactId();

    public DependencyType getDependencyType() {
        return DependencyType.DEFAULT;
    }

    public String getUrl() {
        return null;
    }

    public long getAnnouncementRoleId() {
        return 0L;
    }

    public long getAnnouncementChannelId() {
        return 0L;
    }

    public boolean canAnnounce(User u) {
        return false;
    }

    public UpdateHandler getUpdateHandler() {
        return null;
    }

    public Supplier<String> getCustomVersionSupplier() {
        return null;
    }

    public ChangelogProvider getChangelogProvider() {
        return null;
    }

    public VersionUtils.VersionSplits parseVersion() {
        String version = this.getVersion();
        if (version == null) {
            throw new IllegalStateException("No version fetched so far");
        }
        return VersionUtils.parseVersion(version);
    }

    public String getRepoUrl() {
        return String.format("%s%s/%s/maven-metadata.xml", this.getRepoType().getRepoBase(), this.getGroupId().replace('.', '/'), this.getArtifactId());
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public final Role getAnnouncementRole() {
        long rid = this.getAnnouncementRoleId();
        return rid == 0L ? null : Bot.getGuildJda().getRoleById(rid);
    }

    public final TextChannel getAnnouncementChannel() {
        long cid = this.getAnnouncementChannelId();
        return cid == 0L ? null : Bot.getGuildJda().getTextChannelById(cid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getRepoType(), this.getGroupId(), this.getArtifactId()});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VersionedItem)) {
            return false;
        }
        VersionedItem other = (VersionedItem)obj;
        return other.getName().equals(this.getName());
    }

    public String toString() {
        return String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.version == null ? "Unversioned" : this.version);
    }
}

