/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.util.BlockWriter;
import java.util.Map;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

public abstract class AbstractNodeHandler
implements NodeHandler {
    @Override
    public void handleTextNode(TextNode node, DocumentConverter converter) {
        converter.output.write(converter.cleaner.clean(node));
    }

    @Override
    public void handleIgnoredHTMLElement(Element node, DocumentConverter converter) {
        if (node.isBlock()) {
            converter.output.writeBlock(node.toString());
        } else {
            Document doc = node.ownerDocument();
            boolean oldPrettyPrint = doc.outputSettings().prettyPrint();
            doc.outputSettings().prettyPrint(false);
            converter.output.write(node.toString());
            doc.outputSettings().prettyPrint(oldPrettyPrint);
        }
    }

    protected void prependAndRecurse(String prepend, Element node, DocumentConverter converter, Map<String, NodeHandler> nodes) {
        BlockWriter oldOutput = converter.output;
        converter.output = new BlockWriter(oldOutput).setPrependNewlineString(prepend);
        converter.walkNodes(this, node, nodes);
        converter.output = oldOutput;
    }
}

