/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands.moderation;

import com.almightyalpaca.discord.jdabutler.commands.Command;
import java.util.List;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class SoftbanCommand
extends Command {
    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        Member sendMem = event.getMember();
        if (!sendMem.hasPermission(Permission.KICK_MEMBERS)) {
            this.sendFailed(message);
            return;
        }
        if (!channel.getGuild().getSelfMember().hasPermission(Permission.BAN_MEMBERS)) {
            this.reply(event, "I am unable to ban members!");
            return;
        }
        List<Member> mentions = message.getMentionedMembers();
        if (mentions.isEmpty()) {
            this.reply(event, "Please mention someone");
            return;
        }
        Guild guild = event.getGuild();
        Member self = guild.getSelfMember();
        String reason = "Softban by " + sender.getName();
        for (Member member : mentions) {
            if (!self.canInteract(member)) continue;
            guild.ban(member.getUser(), 7).reason(reason).flatMap(v -> guild.unban(member.getUser()).reason(reason)).queue();
        }
    }

    @Override
    public String[] getAliases() {
        return new String[]{"sb"};
    }

    @Override
    public String getHelp() {
        return "Kicks user and clears past messages";
    }

    @Override
    public String getName() {
        return "softban";
    }
}

