/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.commands.Command;
import com.kantenkugel.discordbot.versioncheck.VersionCheckerRegistry;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.audit.ActionType;
import net.dv8tion.jda.api.audit.AuditLogChange;
import net.dv8tion.jda.api.audit.AuditLogKey;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class NotifyCommand
extends Command {
    private static final long BLACKLIST_CHANNEL_ID = 454657809397710859L;
    private static final String[] ALIASES = new String[]{"subscribe"};
    private static final TLongSet BLACKLIST = new TLongHashSet();

    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        List<Role> roles;
        Member member = message.getMember();
        Guild guild = channel.getGuild();
        if (!guild.equals(Bot.getGuildJda())) {
            this.sendFailed(message);
            return;
        }
        if (content.startsWith("blacklist")) {
            if (Bot.isAdmin(sender)) {
                String subContent = content.substring(Math.min("blacklist".length() + 1, content.length()));
                this.handleBlacklist(event, message, subContent);
            } else {
                this.sendFailed(message);
            }
            return;
        }
        if (content.equalsIgnoreCase("list")) {
            EmbedBuilder embed = new EmbedBuilder();
            embed.setDescription("You can subscribe to one of the following items. To unsubscribe simply type the command again.");
            VersionCheckerRegistry.getVersionedItems().stream().filter(item -> item.getAnnouncementRole() != null).map(item -> new MessageEmbed.Field(item.getName().toUpperCase(), item.getDescription() + "\nCommand: `!notify " + item.getName().toLowerCase() + "`", false)).forEach(embed::addField);
            embed.addField("JDA-EXPERIMENTAL", "Experimental builds of JDA. Grants access to <#289742061220134912>.\nCommand: `!notify experimental`", false);
            this.reply(event, embed.build());
            return;
        }
        if (BLACKLIST.contains(sender.getIdLong())) {
            message.addReaction("\ud83d\ude49").queue();
            return;
        }
        if (content.trim().isEmpty()) {
            roles = VersionCheckerRegistry.getVersionedItems().stream().filter(item -> item.getAnnouncementRole() != null && item.getAnnouncementChannelId() == channel.getIdLong()).map(VersionedItem::getAnnouncementRole).distinct().collect(Collectors.toList());
            if (roles.size() == 0) {
                NotifyCommand.respond(message, "No role(s) set up for this channel");
            }
        } else {
            roles = VersionCheckerRegistry.getItemsFromString(content, false).stream().map(VersionedItem::getAnnouncementRole).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (content.contains("experimental")) {
                roles.add(VersionCheckerRegistry.EXPERIMENTAL_ITEM.getAnnouncementRole());
            }
            if (roles.size() == 0) {
                NotifyCommand.respond(message, "No role(s) found for query");
            }
        }
        if (roles.size() == 0) {
            return;
        }
        List<Role> missingRoles = roles.stream().filter(r -> !member.getRoles().contains(r)).collect(Collectors.toList());
        if (missingRoles.size() > 0) {
            guild.modifyMemberRoles(member, missingRoles, null).reason("Notify command").queue(vd -> {
                NotifyCommand.logRoleAddition(sender, missingRoles);
                NotifyCommand.respond(message, "Added you to role(s) " + NotifyCommand.getRoleListString(missingRoles));
            }, e -> {
                Bot.LOG.error("Could not add role(s) to user {}", (Object)sender.getIdLong(), e);
                NotifyCommand.respond(message, "There was an error adding roles. Please notify the devs.");
            });
        } else {
            guild.modifyMemberRoles(member, null, roles).reason("Notify command").queue(vd -> {
                NotifyCommand.logRoleRemoval(sender, roles);
                NotifyCommand.respond(message, "Removed you from role(s) " + NotifyCommand.getRoleListString(roles));
            }, e -> {
                Bot.LOG.error("Could not remove role(s) from user {}", (Object)sender.getIdLong(), e);
                NotifyCommand.respond(message, "There was an error removing roles. Please notify the devs.");
            });
        }
    }

    private static void logRoleRemoval(User sender, List<Role> roles) {
        String msg = String.format("Removed %#s (%d) from %s", sender, sender.getIdLong(), NotifyCommand.getRoleListString(roles));
        Bot.LOG.info(msg);
    }

    private static void logRoleAddition(User sender, List<Role> roles) {
        String msg = String.format("Added %#s (%d) to %s", sender, sender.getIdLong(), NotifyCommand.getRoleListString(roles));
        Bot.LOG.info(msg);
    }

    private static String getRoleListString(List<Role> roles) {
        return roles.stream().map(r -> '`' + r.getName() + '`').collect(Collectors.joining(", "));
    }

    @Override
    public String[] getAliases() {
        return ALIASES;
    }

    @Override
    public String getHelp() {
        return "Notifies you about updates. Usage: `!notify [item...]` or `!notify list` for a list of subscription options.";
    }

    @Override
    public String getName() {
        return "notify";
    }

    public static void reloadBlacklist(GuildMessageReceivedEvent event) {
        TextChannel blacklistChannel = NotifyCommand.getBlacklistChannel();
        BLACKLIST.clear();
        blacklistChannel.getIterableHistory().forEachAsync(message -> {
            block2: {
                String[] split = message.getContentRaw().split("\\s+");
                try {
                    long userId = Long.parseUnsignedLong(split[0]);
                    BLACKLIST.add(userId);
                }
                catch (NumberFormatException ex) {
                    if (event == null) break block2;
                    event.getChannel().sendMessageFormat("Message `%s` is not a valid blacklist message", message.getContentStripped()).queue(msg -> NotifyCommand.linkMessage(event.getMessageIdLong(), msg.getIdLong()));
                }
            }
            return true;
        }).thenRun(() -> {
            if (event != null) {
                event.getChannel().sendMessage("Reloaded " + BLACKLIST.size() + " users into blacklist").queue(msg -> NotifyCommand.linkMessage(event.getMessageIdLong(), msg.getIdLong()));
            }
        });
    }

    private void handleBlacklist(GuildMessageReceivedEvent event, Message msg, String content) {
        if (content.isEmpty()) {
            this.sendFailed(msg);
            return;
        }
        String[] args = content.split("\\s+", 2);
        TextChannel blacklistChannel = NotifyCommand.getBlacklistChannel();
        switch (args[0].toLowerCase()) {
            case "fetch": 
            case "generate": 
            case "get": {
                TextChannel searchChannel;
                TextChannel textChannel = searchChannel = msg.getMentionedChannels().isEmpty() ? VersionCheckerRegistry.getItem("jda").getAnnouncementChannel() : msg.getMentionedChannels().get(0);
                if (searchChannel == null) {
                    this.reply(event, "Could not determine channel to search in");
                    break;
                }
                this.fetchBlacklist(searchChannel, event);
                break;
            }
            case "update": 
            case "import": 
            case "reload": {
                NotifyCommand.reloadBlacklist(event);
                break;
            }
            case "add": {
                msg.getMentionedUsers().forEach(u -> {
                    if (!BLACKLIST.contains(u.getIdLong())) {
                        BLACKLIST.add(u.getIdLong());
                        NotifyCommand.sendBlacklistAdditionMessage(blacklistChannel, u);
                    }
                });
                msg.addReaction("\u2705").queue();
                break;
            }
            case "rm": 
            case "remove": {
                TLongHashSet removedIds = new TLongHashSet();
                msg.getMentionedUsers().forEach(u -> {
                    if (BLACKLIST.contains(u.getIdLong())) {
                        BLACKLIST.remove(u.getIdLong());
                        removedIds.add(u.getIdLong());
                    }
                });
                NotifyCommand.removeFromChannel(blacklistChannel, removedIds);
                msg.addReaction("\u2705").queue();
                break;
            }
            default: {
                this.reply(event, "Unknown subcommand");
            }
        }
    }

    private void fetchBlacklist(TextChannel searchChannel, GuildMessageReceivedEvent event) {
        Message mentionMessage = searchChannel.getIterableHistory().stream().filter(message -> message.getAuthor().isBot() && !message.getMentionedRoles().isEmpty()).limit(500L).findFirst().orElse(null);
        if (mentionMessage == null) {
            this.reply(event, "Could not find announcement message within 500 messages");
            return;
        }
        Role announcementRole = mentionMessage.getMentionedRoles().get(0);
        OffsetDateTime abortTime = mentionMessage.getTimeCreated();
        TLongHashSet blacklistedUsers = new TLongHashSet();
        searchChannel.getGuild().retrieveAuditLogs().type(ActionType.MEMBER_ROLE_UPDATE).forEachAsync(log -> {
            if (log.getTimeCreated().isBefore(abortTime)) {
                return false;
            }
            AuditLogChange removedRoles = log.getChangeByKey(AuditLogKey.MEMBER_ROLES_REMOVE);
            if (removedRoles == null) {
                return true;
            }
            if (log.getUser() == null || log.getUser().isBot() || !Bot.isAdmin(log.getUser())) {
                return true;
            }
            List removedRoleMap = (List)removedRoles.getNewValue();
            if (removedRoleMap.stream().mapToLong(map -> Long.parseUnsignedLong((String)map.get("id"))).noneMatch(rem -> rem == announcementRole.getIdLong())) {
                return true;
            }
            blacklistedUsers.add(log.getTargetIdLong());
            return true;
        }).thenRun(() -> {
            if (blacklistedUsers.isEmpty() || blacklistedUsers.removeAll(BLACKLIST) && blacklistedUsers.isEmpty()) {
                this.reply(event, "No1 matching blacklist criteria found!");
                return;
            }
            BLACKLIST.addAll(blacklistedUsers);
            TextChannel blacklistChannel = NotifyCommand.getBlacklistChannel();
            blacklistedUsers.forEach(userId -> {
                NotifyCommand.sendBlacklistAdditionMessage(blacklistChannel, Bot.jda.getUserById(userId));
                return true;
            });
            this.reply(event, "Added " + blacklistedUsers.size() + " users to notify blacklist");
        });
    }

    private static void sendBlacklistAdditionMessage(TextChannel blacklistChannel, User blacklisted) {
        blacklistChannel.sendMessageFormat("%d - %#s", blacklisted.getIdLong(), blacklisted).queue();
    }

    private static void removeFromChannel(TextChannel blacklistChannel, TLongSet toRemove) {
        if (toRemove.isEmpty()) {
            return;
        }
        blacklistChannel.getIterableHistory().forEachAsync(msg -> {
            String[] splits = msg.getContentRaw().split("\\s+");
            try {
                long idFromMessage = Long.parseUnsignedLong(splits[0]);
                if (toRemove.contains(idFromMessage)) {
                    toRemove.remove(idFromMessage);
                    msg.delete().queue();
                    if (toRemove.isEmpty()) {
                        return false;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        });
    }

    private static TextChannel getBlacklistChannel() {
        return Bot.jda.getTextChannelById(454657809397710859L);
    }

    private static void respond(Message origMsg, String newMessageContent) {
        origMsg.getChannel().sendMessage(newMessageContent).queue(responseMsg -> {
            responseMsg.delete().queueAfter(10L, TimeUnit.SECONDS);
            origMsg.delete().queueAfter(10L, TimeUnit.SECONDS);
        });
    }
}

