/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.managers;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.managers.PermOverrideManager;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.managers.ManagerBase;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.cache.SnowflakeReference;
import okhttp3.RequestBody;

public class PermOverrideManagerImpl
extends ManagerBase<PermOverrideManager>
implements PermOverrideManager {
    protected final SnowflakeReference<PermissionOverride> override;
    protected final boolean role;
    protected long allowed;
    protected long denied;

    public PermOverrideManagerImpl(PermissionOverride override) {
        super(override.getJDA(), Route.Channels.MODIFY_PERM_OVERRIDE.compile(override.getChannel().getId(), override.getId()));
        this.override = this.setupReferent(override);
        this.role = override.isRoleOverride();
        this.allowed = override.getAllowedRaw();
        this.denied = override.getDeniedRaw();
        if (PermOverrideManagerImpl.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
    }

    private SnowflakeReference<PermissionOverride> setupReferent(PermissionOverride override) {
        JDA api = override.getJDA();
        GuildChannel channel = override.getChannel();
        long channelId = channel.getIdLong();
        ChannelType type = channel.getType();
        boolean role = override.isRoleOverride();
        return new SnowflakeReference<PermissionOverride>(override, holderId -> {
            GuildChannel targetChannel = api.getGuildChannelById(type, channelId);
            if (targetChannel == null) {
                return null;
            }
            Guild guild = targetChannel.getGuild();
            IPermissionHolder holder = role ? guild.getRoleById(holderId) : guild.getMemberById(holderId);
            if (holder == null) {
                return null;
            }
            return targetChannel.getPermissionOverride(holder);
        });
    }

    private void setupValues() {
        if (!this.shouldUpdate(2L)) {
            this.allowed = this.getPermissionOverride().getAllowedRaw();
        }
        if (!this.shouldUpdate(1L)) {
            this.denied = this.getPermissionOverride().getDeniedRaw();
        }
    }

    @Override
    @Nonnull
    public PermissionOverride getPermissionOverride() {
        return this.override.resolve();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public PermOverrideManagerImpl reset(long fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public PermOverrideManagerImpl reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public PermOverrideManagerImpl reset() {
        super.reset();
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public PermOverrideManagerImpl grant(long permissions) {
        if (permissions == 0L) {
            return this;
        }
        this.setupValues();
        this.allowed |= permissions;
        this.denied &= permissions ^ 0xFFFFFFFFFFFFFFFFL;
        this.set |= 3L;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public PermOverrideManagerImpl deny(long permissions) {
        if (permissions == 0L) {
            return this;
        }
        this.setupValues();
        this.denied |= permissions;
        this.allowed &= permissions ^ 0xFFFFFFFFFFFFFFFFL;
        this.set |= 3L;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public PermOverrideManagerImpl clear(long permissions) {
        this.setupValues();
        if ((this.allowed & permissions) != 0L) {
            this.allowed &= permissions ^ 0xFFFFFFFFFFFFFFFFL;
            this.set |= 2L;
        }
        if ((this.denied & permissions) != 0L) {
            this.denied &= permissions ^ 0xFFFFFFFFFFFFFFFFL;
            this.set |= 1L;
        }
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        String targetId = this.override.getId();
        this.setupValues();
        RequestBody data = this.getRequestBody(DataObject.empty().put("id", targetId).put("type", this.role ? "role" : "member").put("allow", this.allowed).put("deny", this.denied));
        this.reset();
        return data;
    }

    @Override
    protected boolean checkPermissions() {
        if (!this.getGuild().getSelfMember().hasPermission(this.getChannel(), Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(this.getChannel(), Permission.MANAGE_PERMISSIONS);
        }
        return super.checkPermissions();
    }
}

