/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.managers;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.SelfUser;
import net.dv8tion.jda.api.managers.AccountManager;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.managers.ManagerBase;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.Checks;
import okhttp3.RequestBody;

public class AccountManagerImpl
extends ManagerBase<AccountManager>
implements AccountManager {
    protected final SelfUser selfUser;
    protected String currentPassword;
    protected String name;
    protected Icon avatar;
    protected String email;
    protected String password;

    public AccountManagerImpl(SelfUser selfUser) {
        super(selfUser.getJDA(), Route.Self.MODIFY_SELF.compile(new String[0]));
        this.selfUser = selfUser;
    }

    @Override
    @Nonnull
    public SelfUser getSelfUser() {
        return this.selfUser;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl reset(long fields) {
        super.reset(fields);
        if ((fields & 2L) == 2L) {
            this.avatar = null;
        }
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl reset() {
        super.reset();
        this.avatar = null;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl setName(@Nonnull String name, String currentPassword) {
        Checks.notBlank(name, "Name");
        Checks.check(name.length() >= 2 && name.length() <= 32, "Name must be between 2-32 characters long");
        this.currentPassword = currentPassword;
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl setAvatar(Icon avatar, String currentPassword) {
        this.currentPassword = currentPassword;
        this.avatar = avatar;
        this.set |= 2L;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public AccountManagerImpl setEmail(@Nonnull String email, @Nonnull String currentPassword) {
        Checks.notNull(email, "email");
        this.currentPassword = currentPassword;
        this.email = email;
        this.set |= 4L;
        return this;
    }

    @Override
    @CheckReturnValue
    public AccountManagerImpl setPassword(@Nonnull String newPassword, @Nonnull String currentPassword) {
        Checks.notNull(newPassword, "password");
        Checks.check(newPassword.length() >= 6 && newPassword.length() <= 128, "Password must be between 2-128 characters long");
        this.currentPassword = currentPassword;
        this.password = newPassword;
        this.set |= 8L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        boolean isClient = this.getJDA().getAccountType() == AccountType.CLIENT;
        Checks.check(!isClient || this.currentPassword != null && !this.currentPassword.isEmpty(), "Provided client account password to be used in auth is null or empty!");
        DataObject body = DataObject.empty();
        body.put("username", this.getSelfUser().getName());
        body.put("avatar", this.getSelfUser().getAvatarId());
        if (this.shouldUpdate(1L)) {
            body.put("username", this.name);
        }
        if (this.shouldUpdate(2L)) {
            body.put("avatar", this.avatar == null ? null : this.avatar.getEncoding());
        }
        if (isClient) {
            body.put("password", this.currentPassword);
            body.put("email", this.email);
            if (this.shouldUpdate(4L)) {
                body.put("email", this.email);
            }
            if (this.shouldUpdate(8L)) {
                body.put("new_password", this.password);
            }
        }
        this.reset();
        return this.getRequestBody(body);
    }

    @Override
    protected void handleSuccess(Response response, Request<Void> request) {
        String newToken = response.getObject().getString("token").replace("Bot ", "");
        this.api.setToken(newToken);
        request.onSuccess(null);
    }
}

