/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.requests;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.exceptions.ContextException;
import net.dv8tion.jda.api.exceptions.RateLimitedException;
import net.dv8tion.jda.api.utils.concurrent.DelayedCompletableFuture;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.operator.DelayRestAction;
import net.dv8tion.jda.internal.requests.restaction.operator.FlatMapRestAction;
import net.dv8tion.jda.internal.requests.restaction.operator.MapRestAction;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.ContextRunnable;

public interface RestAction<T> {
    public static void setPassContext(boolean enable) {
        RestActionImpl.setPassContext(enable);
    }

    public static boolean isPassContext() {
        return RestActionImpl.isPassContext();
    }

    public static void setDefaultFailure(@Nullable Consumer<? super Throwable> callback) {
        RestActionImpl.setDefaultFailure(callback);
    }

    public static void setDefaultSuccess(@Nullable Consumer<Object> callback) {
        RestActionImpl.setDefaultSuccess(callback);
    }

    @Nonnull
    public static Consumer<? super Throwable> getDefaultFailure() {
        return RestActionImpl.getDefaultFailure();
    }

    @Nonnull
    public static Consumer<Object> getDefaultSuccess() {
        return RestActionImpl.getDefaultSuccess();
    }

    @Nonnull
    public JDA getJDA();

    @Nonnull
    public RestAction<T> setCheck(@Nullable BooleanSupplier var1);

    default public void queue() {
        this.queue(null);
    }

    default public void queue(@Nullable Consumer<? super T> success) {
        this.queue(success, null);
    }

    public void queue(@Nullable Consumer<? super T> var1, @Nullable Consumer<? super Throwable> var2);

    default public T complete() {
        try {
            return this.complete(true);
        }
        catch (RateLimitedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public T complete(boolean var1) throws RateLimitedException;

    @Nonnull
    default public CompletableFuture<T> submit() {
        return this.submit(true);
    }

    @Nonnull
    public CompletableFuture<T> submit(boolean var1);

    @Nonnull
    @CheckReturnValue
    default public <O> RestAction<O> map(@Nonnull Function<? super T, ? extends O> map) {
        Checks.notNull(map, "Function");
        return new MapRestAction<T, O>(this, map);
    }

    @Nonnull
    @CheckReturnValue
    default public <O> RestAction<O> flatMap(@Nonnull Function<? super T, ? extends RestAction<O>> flatMap) {
        return this.flatMap(null, flatMap);
    }

    @Nonnull
    @CheckReturnValue
    default public <O> RestAction<O> flatMap(@Nullable Predicate<? super T> condition, @Nonnull Function<? super T, ? extends RestAction<O>> flatMap) {
        Checks.notNull(flatMap, "Function");
        return new FlatMapRestAction(this, condition, flatMap);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<T> delay(@Nonnull Duration duration) {
        return this.delay(duration, null);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<T> delay(@Nonnull Duration duration, @Nullable ScheduledExecutorService scheduler) {
        Checks.notNull(duration, "Duration");
        return new DelayRestAction(this, TimeUnit.MILLISECONDS, duration.toMillis(), scheduler);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<T> delay(long delay, @Nonnull TimeUnit unit) {
        return this.delay(delay, unit, null);
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<T> delay(long delay, @Nonnull TimeUnit unit, @Nullable ScheduledExecutorService scheduler) {
        Checks.notNull((Object)unit, "TimeUnit");
        return new DelayRestAction(this, unit, delay, scheduler);
    }

    @Nonnull
    default public DelayedCompletableFuture<T> submitAfter(long delay, @Nonnull TimeUnit unit) {
        return this.submitAfter(delay, unit, null);
    }

    @Nonnull
    default public DelayedCompletableFuture<T> submitAfter(long delay, @Nonnull TimeUnit unit, @Nullable ScheduledExecutorService executor) {
        Checks.notNull((Object)unit, "TimeUnit");
        if (executor == null) {
            executor = this.getJDA().getRateLimitPool();
        }
        return DelayedCompletableFuture.make(executor, delay, unit, task -> {
            Consumer<Throwable> onFailure = RestAction.isPassContext() ? ContextException.here(task::completeExceptionally) : task::completeExceptionally;
            return new ContextRunnable(() -> this.queue(task::complete, onFailure));
        });
    }

    default public T completeAfter(long delay, @Nonnull TimeUnit unit) {
        Checks.notNull((Object)unit, "TimeUnit");
        try {
            unit.sleep(delay);
            return this.complete();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    default public ScheduledFuture<?> queueAfter(long delay, @Nonnull TimeUnit unit) {
        return this.queueAfter(delay, unit, null, null, null);
    }

    @Nonnull
    default public ScheduledFuture<?> queueAfter(long delay, @Nonnull TimeUnit unit, @Nullable Consumer<? super T> success) {
        return this.queueAfter(delay, unit, success, null, null);
    }

    @Nonnull
    default public ScheduledFuture<?> queueAfter(long delay, @Nonnull TimeUnit unit, @Nullable Consumer<? super T> success, @Nullable Consumer<? super Throwable> failure) {
        return this.queueAfter(delay, unit, success, failure, null);
    }

    @Nonnull
    default public ScheduledFuture<?> queueAfter(long delay, @Nonnull TimeUnit unit, @Nullable ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, null, null, executor);
    }

    @Nonnull
    default public ScheduledFuture<?> queueAfter(long delay, @Nonnull TimeUnit unit, @Nullable Consumer<? super T> success, @Nullable ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, success, null, executor);
    }

    @Nonnull
    default public ScheduledFuture<?> queueAfter(long delay, @Nonnull TimeUnit unit, @Nullable Consumer<? super T> success, @Nullable Consumer<? super Throwable> failure, @Nullable ScheduledExecutorService executor) {
        Checks.notNull((Object)unit, "TimeUnit");
        if (executor == null) {
            executor = this.getJDA().getRateLimitPool();
        }
        Consumer<? super Throwable> onFailure = RestAction.isPassContext() ? ContextException.here(failure == null ? RestAction.getDefaultFailure() : failure) : failure;
        ContextRunnable task = new ContextRunnable(() -> this.queue(success, onFailure));
        return executor.schedule(task, delay, unit);
    }
}

