/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.util.gradle;

import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GradleUtil {
    public static final Collection<Pair<String, String>> DEFAULT_PLUGINS = Arrays.asList(new ImmutablePair<String, Object>("java", null), new ImmutablePair<String, Object>("application", null), new ImmutablePair<String, String>("com.github.johnrengelman.shadow", "4.0.4"));
    public static final String SHADOW_VERSION = "4.0.4";

    public static String getBuildFile(Collection<Pair<String, String>> plugins, String mainClassName, String version, String sourceCompatibility, List<VersionedItem> items, boolean pretty) {
        return GradleUtil.getPluginsBlock(plugins) + "\n\nmainClassName = '" + mainClassName + '\'' + "\n\nversion '" + version + '\'' + "\n\nsourceCompatibility = " + sourceCompatibility + "\n\n" + GradleUtil.getRepositoryBlock(items) + "\n\n" + GradleUtil.getDependencyBlock(items, pretty) + "\n\ncompileJava.options.encoding = 'UTF-8'\n";
    }

    public static String getDependencyBlock(List<VersionedItem> items, boolean pretty) {
        StringBuilder text = new StringBuilder("dependencies {\n");
        for (VersionedItem item : items) {
            text.append("    ").append(GradleUtil.getDependencyString(item, pretty)).append("\n");
        }
        text.append("}");
        return text.toString();
    }

    public static String getDependencyString(VersionedItem item, boolean pretty) {
        if (pretty) {
            return String.format("compile group: '%s', name: '%s', version: '%s'", item.getGroupId(), item.getArtifactId(), item.getVersion());
        }
        return String.format("compile '%s:%s:%s'", item.getGroupId(), item.getArtifactId(), item.getVersion());
    }

    public static String getPluginsBlock(Collection<Pair<String, String>> plugins) {
        StringBuilder text = new StringBuilder("plugins {\n");
        for (Pair<String, String> plugin : plugins) {
            text.append("    id'").append(plugin.getLeft()).append("'");
            if (plugin.getRight() != null) {
                text.append(" version '").append(plugin.getRight()).append("'");
            }
            text.append("\n");
        }
        text.append("}");
        return text.toString();
    }

    public static String getRepositoryBlock(List<VersionedItem> items) {
        StringBuilder text = new StringBuilder("repositories {\n");
        items.stream().map(item -> item.getRepoType().getGradleImport()).filter(Objects::nonNull).distinct().forEach(pair -> text.append(GradleUtil.getRepositoryString((String)pair.getLeft(), (String)pair.getRight(), "    ")).append("\n"));
        text.append("}");
        return text.toString();
    }

    public static String getRepositoryString(String name, String url, String indentation) {
        if (indentation == null) {
            indentation = "";
        }
        if (url == null) {
            return indentation + name;
        }
        return indentation + "maven {\n" + indentation + "    name '" + name + "'\n" + indentation + "    url '" + url + "'\n" + indentation + "}";
    }
}

