/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import com.almightyalpaca.discord.jdabutler.EventListener;
import com.almightyalpaca.discord.jdabutler.commands.Dispatcher;
import com.almightyalpaca.discord.jdabutler.commands.commands.NotifyCommand;
import com.almightyalpaca.discord.jdabutler.config.Config;
import com.almightyalpaca.discord.jdabutler.config.ConfigFactory;
import com.almightyalpaca.discord.jdabutler.config.exception.KeyNotFoundException;
import com.almightyalpaca.discord.jdabutler.config.exception.WrongTypeException;
import com.almightyalpaca.discord.jdabutler.util.MiscUtils;
import com.almightyalpaca.discord.jdabutler.util.gradle.GradleProjectDropboxUtil;
import com.almightyalpaca.discord.jdabutler.util.logging.WebhookAppender;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.kantenkugel.discordbot.jdocparser.JDoc;
import com.kantenkugel.discordbot.versioncheck.VersionCheckerRegistry;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.utils.ChunkingFilter;
import net.dv8tion.jda.internal.JDAImpl;
import okhttp3.OkHttpClient;
import org.slf4j.LoggerFactory;

public class Bot {
    public static Config config;
    public static Dispatcher dispatcher;
    public static final String INVITE_LINK = "https://discord.gg/0hMr4ce0tIk3pSjp";
    public static JDAImpl jda;
    public static boolean isStealth;
    public static OkHttpClient httpClient;
    public static EventListener listener;
    public static final Logger LOG;
    public static final ScheduledExecutorService EXECUTOR;

    public static Guild getGuildJda() {
        return jda.getGuildById("125227483518861312");
    }

    public static Role getRoleBots() {
        return Bot.getGuildJda().getRoleById("125616720156033024");
    }

    public static Role getRoleStaff() {
        return Bot.getGuildJda().getRoleById("169481978268090369");
    }

    public static boolean isAdmin(User user) {
        Member member = Bot.getGuildJda().getMember(user);
        return member != null && member.getRoles().contains(Bot.getRoleStaff());
    }

    public static Role getRoleHelper() {
        return Bot.getGuildJda().getRoleById("183963327033114624");
    }

    public static boolean isHelper(User user) {
        if (Bot.isAdmin(user)) {
            return true;
        }
        Member member = Bot.getGuildJda().getMember(user);
        return member != null && member.getRoles().contains(Bot.getRoleHelper());
    }

    public static void main(String[] args) throws JsonIOException, JsonSyntaxException, WrongTypeException, KeyNotFoundException, IOException, LoginException, IllegalArgumentException, InterruptedException, SecurityException {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> LOG.error("There was an uncaught exception in thread {}", (Object)thread.getName(), (Object)throwable));
        httpClient = new OkHttpClient();
        EXECUTOR.submit(JDoc::init);
        config = ConfigFactory.getConfig(new File("config.json"));
        JDABuilder builder = new JDABuilder(AccountType.BOT);
        builder.setBulkDeleteSplittingEnabled(false);
        String token = config.getString("discord.token", "Your token");
        builder.setToken(token);
        builder.setChunkingFilter(ChunkingFilter.NONE);
        config.save();
        listener = new EventListener();
        builder.addEventListeners(listener);
        Object[] objectArray = new Object[1];
        dispatcher = new Dispatcher();
        objectArray[0] = dispatcher;
        builder.addEventListeners(objectArray);
        builder.setActivity(Activity.playing("JDA"));
        jda = (JDAImpl)builder.build().awaitReady();
        if (config.getBoolean("webhook.enabled", false)) {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            ThresholdFilter filter = new ThresholdFilter();
            filter.setLevel(config.getString("webhook.level"));
            filter.setContext(lc);
            filter.start();
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setPattern(config.getString("webhook.pattern"));
            encoder.setContext(lc);
            encoder.start();
            WebhookAppender appender = new WebhookAppender();
            appender.setEncoder(encoder);
            appender.addFilter(filter);
            appender.setWebhookUrl(config.getString("webhook.webhookurl"));
            appender.setName("ERROR_WH");
            appender.setContext(lc);
            appender.start();
            Logger root = (Logger)LoggerFactory.getLogger("ROOT");
            root.addAppender(appender);
        }
        NotifyCommand.reloadBlacklist(null);
        EXECUTOR.submit(() -> {
            VersionCheckerRegistry.init();
            VersionedItem jdaItem = VersionCheckerRegistry.getItem("jda");
            if (jdaItem.getVersion() != null && jdaItem.parseVersion().build != config.getInt("jda.version.build")) {
                jdaItem.getUpdateHandler().onUpdate(jdaItem, config.getString("jda.version.name"), false);
            } else {
                GradleProjectDropboxUtil.fetchUrl();
            }
        });
    }

    public static void shutdown() {
        Bot.shutdown(0);
    }

    public static void shutdown(int code) {
        jda.getRegisteredListeners().forEach(xva$0 -> jda.removeEventListener(xva$0));
        try {
            TimeUnit.SECONDS.sleep(2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        jda.shutdownNow();
        System.exit(code);
    }

    static {
        isStealth = false;
        LOG = (Logger)LoggerFactory.getLogger(Bot.class);
        EXECUTOR = Executors.newSingleThreadScheduledExecutor(MiscUtils.newThreadFactory("main-executor"));
    }
}

