/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck.items;

import com.kantenkugel.discordbot.versioncheck.DependencyType;
import com.kantenkugel.discordbot.versioncheck.RepoType;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.Arrays;
import java.util.List;
import net.dv8tion.jda.api.entities.User;

public class SimpleVersionedItem
extends VersionedItem {
    private final String name;
    private List<String> aliases;
    private final RepoType repoType;
    private final DependencyType depType;
    private final String groupId;
    private final String artifactId;
    private String url;
    private long roleId = 0L;
    private long channelId = 0L;
    private final TLongSet allowedAnnouncers = new TLongHashSet();

    public SimpleVersionedItem(String name, RepoType repoType, DependencyType depType, String groupId, String artifactId) {
        this.name = name;
        this.repoType = repoType;
        this.depType = depType;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public SimpleVersionedItem setAliases(String ... aliases) {
        this.aliases = Arrays.asList(aliases);
        return this;
    }

    public SimpleVersionedItem setUrl(String url) {
        this.url = url;
        return this;
    }

    public SimpleVersionedItem setAnnouncementRoleId(long roleId) {
        this.roleId = roleId;
        return this;
    }

    public SimpleVersionedItem setAnnouncementChannelId(long channelId) {
        this.channelId = channelId;
        return this;
    }

    public SimpleVersionedItem addAnnouncementWhitelist(long ... userIds) {
        this.allowedAnnouncers.addAll(userIds);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Announcements for " + this.getName();
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public RepoType getRepoType() {
        return this.repoType;
    }

    @Override
    public DependencyType getDependencyType() {
        return this.depType;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public long getAnnouncementRoleId() {
        return this.roleId;
    }

    @Override
    public long getAnnouncementChannelId() {
        return this.channelId;
    }

    @Override
    public boolean canAnnounce(User u) {
        return this.allowedAnnouncers.contains(u.getIdLong());
    }
}

