/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.LinkAudience;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class SharedContentChangeLinkAudienceDetails {
    protected final long targetAssetIndex;
    protected final String originalFolderName;
    protected final String sharedFolderType;
    protected final LinkAudience newValue;
    protected final LinkAudience previousValue;

    public SharedContentChangeLinkAudienceDetails(long targetAssetIndex, LinkAudience newValue, String originalFolderName, String sharedFolderType, LinkAudience previousValue) {
        this.targetAssetIndex = targetAssetIndex;
        this.originalFolderName = originalFolderName;
        this.sharedFolderType = sharedFolderType;
        if (newValue == null) {
            throw new IllegalArgumentException("Required value for 'newValue' is null");
        }
        this.newValue = newValue;
        this.previousValue = previousValue;
    }

    public SharedContentChangeLinkAudienceDetails(long targetAssetIndex, LinkAudience newValue) {
        this(targetAssetIndex, newValue, null, null, null);
    }

    public long getTargetAssetIndex() {
        return this.targetAssetIndex;
    }

    public LinkAudience getNewValue() {
        return this.newValue;
    }

    public String getOriginalFolderName() {
        return this.originalFolderName;
    }

    public String getSharedFolderType() {
        return this.sharedFolderType;
    }

    public LinkAudience getPreviousValue() {
        return this.previousValue;
    }

    public static Builder newBuilder(long targetAssetIndex, LinkAudience newValue) {
        return new Builder(targetAssetIndex, newValue);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.targetAssetIndex, this.originalFolderName, this.sharedFolderType, this.newValue, this.previousValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedContentChangeLinkAudienceDetails other = (SharedContentChangeLinkAudienceDetails)obj;
            return this.targetAssetIndex == other.targetAssetIndex && (this.newValue == other.newValue || this.newValue.equals((Object)other.newValue)) && (this.originalFolderName == other.originalFolderName || this.originalFolderName != null && this.originalFolderName.equals(other.originalFolderName)) && (this.sharedFolderType == other.sharedFolderType || this.sharedFolderType != null && this.sharedFolderType.equals(other.sharedFolderType)) && (this.previousValue == other.previousValue || this.previousValue != null && this.previousValue.equals((Object)other.previousValue));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedContentChangeLinkAudienceDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedContentChangeLinkAudienceDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("target_asset_index");
            StoneSerializers.uInt64().serialize((Long)value.targetAssetIndex, g);
            g.writeFieldName("new_value");
            LinkAudience.Serializer.INSTANCE.serialize(value.newValue, g);
            if (value.originalFolderName != null) {
                g.writeFieldName("original_folder_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.originalFolderName, g);
            }
            if (value.sharedFolderType != null) {
                g.writeFieldName("shared_folder_type");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.sharedFolderType, g);
            }
            if (value.previousValue != null) {
                g.writeFieldName("previous_value");
                StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).serialize(value.previousValue, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedContentChangeLinkAudienceDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            LinkAudience f_previousValue;
            String f_sharedFolderType;
            String f_originalFolderName;
            LinkAudience f_newValue;
            Long f_targetAssetIndex;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_targetAssetIndex = null;
                f_newValue = null;
                f_originalFolderName = null;
                f_sharedFolderType = null;
                f_previousValue = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("target_asset_index".equals(field)) {
                        f_targetAssetIndex = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("new_value".equals(field)) {
                        f_newValue = LinkAudience.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("original_folder_name".equals(field)) {
                        f_originalFolderName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("shared_folder_type".equals(field)) {
                        f_sharedFolderType = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("previous_value".equals(field)) {
                        f_previousValue = StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_targetAssetIndex == null) {
                    throw new JsonParseException(p, "Required field \"target_asset_index\" missing.");
                }
                if (f_newValue == null) {
                    throw new JsonParseException(p, "Required field \"new_value\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedContentChangeLinkAudienceDetails value = new SharedContentChangeLinkAudienceDetails(f_targetAssetIndex, f_newValue, f_originalFolderName, f_sharedFolderType, f_previousValue);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final long targetAssetIndex;
        protected final LinkAudience newValue;
        protected String originalFolderName;
        protected String sharedFolderType;
        protected LinkAudience previousValue;

        protected Builder(long targetAssetIndex, LinkAudience newValue) {
            this.targetAssetIndex = targetAssetIndex;
            if (newValue == null) {
                throw new IllegalArgumentException("Required value for 'newValue' is null");
            }
            this.newValue = newValue;
            this.originalFolderName = null;
            this.sharedFolderType = null;
            this.previousValue = null;
        }

        public Builder withOriginalFolderName(String originalFolderName) {
            this.originalFolderName = originalFolderName;
            return this;
        }

        public Builder withSharedFolderType(String sharedFolderType) {
            this.sharedFolderType = sharedFolderType;
            return this;
        }

        public Builder withPreviousValue(LinkAudience previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        public SharedContentChangeLinkAudienceDetails build() {
            return new SharedContentChangeLinkAudienceDetails(this.targetAssetIndex, this.newValue, this.originalFolderName, this.sharedFolderType, this.previousValue);
        }
    }
}

