/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.team.TeamMemberStatus;
import com.dropbox.core.v2.team.TeamMembershipType;
import com.dropbox.core.v2.users.Name;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class MemberProfile {
    protected final String teamMemberId;
    protected final String externalId;
    protected final String accountId;
    protected final String email;
    protected final boolean emailVerified;
    protected final TeamMemberStatus status;
    protected final Name name;
    protected final TeamMembershipType membershipType;
    protected final Date joinedOn;
    protected final String persistentId;

    public MemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType, String externalId, String accountId, Date joinedOn, String persistentId) {
        if (teamMemberId == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
        }
        this.teamMemberId = teamMemberId;
        this.externalId = externalId;
        if (accountId != null) {
            if (accountId.length() < 40) {
                throw new IllegalArgumentException("String 'accountId' is shorter than 40");
            }
            if (accountId.length() > 40) {
                throw new IllegalArgumentException("String 'accountId' is longer than 40");
            }
        }
        this.accountId = accountId;
        if (email == null) {
            throw new IllegalArgumentException("Required value for 'email' is null");
        }
        this.email = email;
        this.emailVerified = emailVerified;
        if (status == null) {
            throw new IllegalArgumentException("Required value for 'status' is null");
        }
        this.status = status;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (membershipType == null) {
            throw new IllegalArgumentException("Required value for 'membershipType' is null");
        }
        this.membershipType = membershipType;
        this.joinedOn = LangUtil.truncateMillis(joinedOn);
        this.persistentId = persistentId;
    }

    public MemberProfile(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType) {
        this(teamMemberId, email, emailVerified, status, name, membershipType, null, null, null, null);
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean getEmailVerified() {
        return this.emailVerified;
    }

    public TeamMemberStatus getStatus() {
        return this.status;
    }

    public Name getName() {
        return this.name;
    }

    public TeamMembershipType getMembershipType() {
        return this.membershipType;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Date getJoinedOn() {
        return this.joinedOn;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public static Builder newBuilder(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType) {
        return new Builder(teamMemberId, email, emailVerified, status, name, membershipType);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamMemberId, this.externalId, this.accountId, this.email, this.emailVerified, this.status, this.name, this.membershipType, this.joinedOn, this.persistentId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MemberProfile other = (MemberProfile)obj;
            return !(this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.status != other.status && !this.status.equals(other.status) || this.name != other.name && !this.name.equals(other.name) || this.membershipType != other.membershipType && !this.membershipType.equals((Object)other.membershipType) || this.externalId != other.externalId && (this.externalId == null || !this.externalId.equals(other.externalId)) || this.accountId != other.accountId && (this.accountId == null || !this.accountId.equals(other.accountId)) || this.joinedOn != other.joinedOn && (this.joinedOn == null || !this.joinedOn.equals(other.joinedOn)) || this.persistentId != other.persistentId && (this.persistentId == null || !this.persistentId.equals(other.persistentId)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MemberProfile> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MemberProfile value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("team_member_id");
            StoneSerializers.string().serialize(value.teamMemberId, g);
            g.writeFieldName("email");
            StoneSerializers.string().serialize(value.email, g);
            g.writeFieldName("email_verified");
            StoneSerializers.boolean_().serialize((Boolean)value.emailVerified, g);
            g.writeFieldName("status");
            TeamMemberStatus.Serializer.INSTANCE.serialize(value.status, g);
            g.writeFieldName("name");
            Name.Serializer.INSTANCE.serialize(value.name, g);
            g.writeFieldName("membership_type");
            TeamMembershipType.Serializer.INSTANCE.serialize(value.membershipType, g);
            if (value.externalId != null) {
                g.writeFieldName("external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.externalId, g);
            }
            if (value.accountId != null) {
                g.writeFieldName("account_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.accountId, g);
            }
            if (value.joinedOn != null) {
                g.writeFieldName("joined_on");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.joinedOn, g);
            }
            if (value.persistentId != null) {
                g.writeFieldName("persistent_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.persistentId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MemberProfile deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_persistentId;
            Date f_joinedOn;
            String f_accountId;
            String f_externalId;
            TeamMembershipType f_membershipType;
            Name f_name;
            TeamMemberStatus f_status;
            Boolean f_emailVerified;
            String f_email;
            String f_teamMemberId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamMemberId = null;
                f_email = null;
                f_emailVerified = null;
                f_status = null;
                f_name = null;
                f_membershipType = null;
                f_externalId = null;
                f_accountId = null;
                f_joinedOn = null;
                f_persistentId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("email_verified".equals(field)) {
                        f_emailVerified = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("status".equals(field)) {
                        f_status = TeamMemberStatus.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = (Name)Name.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("membership_type".equals(field)) {
                        f_membershipType = TeamMembershipType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("external_id".equals(field)) {
                        f_externalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("joined_on".equals(field)) {
                        f_joinedOn = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("persistent_id".equals(field)) {
                        f_persistentId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamMemberId == null) {
                    throw new JsonParseException(p, "Required field \"team_member_id\" missing.");
                }
                if (f_email == null) {
                    throw new JsonParseException(p, "Required field \"email\" missing.");
                }
                if (f_emailVerified == null) {
                    throw new JsonParseException(p, "Required field \"email_verified\" missing.");
                }
                if (f_status == null) {
                    throw new JsonParseException(p, "Required field \"status\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_membershipType == null) {
                    throw new JsonParseException(p, "Required field \"membership_type\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MemberProfile value = new MemberProfile(f_teamMemberId, f_email, f_emailVerified, f_status, f_name, f_membershipType, f_externalId, f_accountId, f_joinedOn, f_persistentId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String teamMemberId;
        protected final String email;
        protected final boolean emailVerified;
        protected final TeamMemberStatus status;
        protected final Name name;
        protected final TeamMembershipType membershipType;
        protected String externalId;
        protected String accountId;
        protected Date joinedOn;
        protected String persistentId;

        protected Builder(String teamMemberId, String email, boolean emailVerified, TeamMemberStatus status, Name name, TeamMembershipType membershipType) {
            if (teamMemberId == null) {
                throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
            }
            this.teamMemberId = teamMemberId;
            if (email == null) {
                throw new IllegalArgumentException("Required value for 'email' is null");
            }
            this.email = email;
            this.emailVerified = emailVerified;
            if (status == null) {
                throw new IllegalArgumentException("Required value for 'status' is null");
            }
            this.status = status;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (membershipType == null) {
                throw new IllegalArgumentException("Required value for 'membershipType' is null");
            }
            this.membershipType = membershipType;
            this.externalId = null;
            this.accountId = null;
            this.joinedOn = null;
            this.persistentId = null;
        }

        public Builder withExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder withAccountId(String accountId) {
            if (accountId != null) {
                if (accountId.length() < 40) {
                    throw new IllegalArgumentException("String 'accountId' is shorter than 40");
                }
                if (accountId.length() > 40) {
                    throw new IllegalArgumentException("String 'accountId' is longer than 40");
                }
            }
            this.accountId = accountId;
            return this;
        }

        public Builder withJoinedOn(Date joinedOn) {
            this.joinedOn = LangUtil.truncateMillis(joinedOn);
            return this;
        }

        public Builder withPersistentId(String persistentId) {
            this.persistentId = persistentId;
            return this;
        }

        public MemberProfile build() {
            return new MemberProfile(this.teamMemberId, this.email, this.emailVerified, this.status, this.name, this.membershipType, this.externalId, this.accountId, this.joinedOn, this.persistentId);
        }
    }
}

